/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdAsyncRequestSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdAsyncRequest
extends APINode {
    @SerializedName(value="async_request_set")
    private AdAsyncRequestSet mAsyncRequestSet = null;
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="input")
    private Map<String, String> mInput = null;
    @SerializedName(value="result")
    private Map<String, String> mResult = null;
    @SerializedName(value="scope_object_id")
    private String mScopeObjectId = null;
    @SerializedName(value="status")
    private EnumStatus mStatus = null;
    @SerializedName(value="type")
    private String mType = null;
    @SerializedName(value="updated_time")
    private String mUpdatedTime = null;
    protected static Gson gson = null;

    AdAsyncRequest() {
    }

    public AdAsyncRequest(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdAsyncRequest(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdAsyncRequest fetch() throws APIException {
        AdAsyncRequest newInstance = AdAsyncRequest.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdAsyncRequest fetchById(Long id, APIContext context) throws APIException {
        return AdAsyncRequest.fetchById(id.toString(), context);
    }

    public static AdAsyncRequest fetchById(String id, APIContext context) throws APIException {
        AdAsyncRequest adAsyncRequest = new APIRequestGet(id, context).requestAllFields().execute();
        return adAsyncRequest;
    }

    public static APINodeList<AdAsyncRequest> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdAsyncRequest>(context, "", "/", "GET", AdAsyncRequest.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdAsyncRequest loadJSON(String json, APIContext context) {
        AdAsyncRequest adAsyncRequest = (AdAsyncRequest)AdAsyncRequest.getGson().fromJson(json, AdAsyncRequest.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adAsyncRequest.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adAsyncRequest.context = context;
        adAsyncRequest.rawValue = json;
        return adAsyncRequest;
    }

    public static APINodeList<AdAsyncRequest> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block18: {
            APINodeList<AdAsyncRequest> adAsyncRequests = new APINodeList<AdAsyncRequest>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adAsyncRequests.add(AdAsyncRequest.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adAsyncRequests;
                }
                if (!result.isJsonObject()) break block18;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject().get("cursors").getAsJsonObject();
                        String[] before = paging.has("before") ? paging.get("before").getAsString() : null;
                        String after = paging.has("after") ? paging.get("after").getAsString() : null;
                        adAsyncRequests.setPaging((String)before, after);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adAsyncRequests.add(AdAsyncRequest.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adAsyncRequests.add(AdAsyncRequest.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adAsyncRequests.add(AdAsyncRequest.loadJSON(obj.toString(), context));
                        }
                    }
                    return adAsyncRequests;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adAsyncRequests.add(AdAsyncRequest.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adAsyncRequests;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adAsyncRequests.add(AdAsyncRequest.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adAsyncRequests;
                }
                adAsyncRequests.clear();
                adAsyncRequests.add(AdAsyncRequest.loadJSON(json, context));
                return adAsyncRequests;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdAsyncRequest.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public AdAsyncRequestSet getFieldAsyncRequestSet() {
        if (this.mAsyncRequestSet != null) {
            this.mAsyncRequestSet.context = this.getContext();
        }
        return this.mAsyncRequestSet;
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Map<String, String> getFieldInput() {
        return this.mInput;
    }

    public Map<String, String> getFieldResult() {
        return this.mResult;
    }

    public String getFieldScopeObjectId() {
        return this.mScopeObjectId;
    }

    public EnumStatus getFieldStatus() {
        return this.mStatus;
    }

    public String getFieldType() {
        return this.mType;
    }

    public String getFieldUpdatedTime() {
        return this.mUpdatedTime;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdAsyncRequest copyFrom(AdAsyncRequest instance) {
        this.mAsyncRequestSet = instance.mAsyncRequestSet;
        this.mCreatedTime = instance.mCreatedTime;
        this.mId = instance.mId;
        this.mInput = instance.mInput;
        this.mResult = instance.mResult;
        this.mScopeObjectId = instance.mScopeObjectId;
        this.mStatus = instance.mStatus;
        this.mType = instance.mType;
        this.mUpdatedTime = instance.mUpdatedTime;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdAsyncRequest> getParser() {
        return new APIRequest.ResponseParser<AdAsyncRequest>(){

            @Override
            public APINodeList<AdAsyncRequest> parseResponse(String response, APIContext context, APIRequest<AdAsyncRequest> request) throws APIException.MalformedResponseException {
                return AdAsyncRequest.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumStatuses {
        VALUE_INITIAL("INITIAL"),
        VALUE_IN_PROGRESS("IN_PROGRESS"),
        VALUE_SUCCESS("SUCCESS"),
        VALUE_ERROR("ERROR"),
        VALUE_CANCELED("CANCELED"),
        VALUE_PENDING_DEPENDENCY("PENDING_DEPENDENCY"),
        VALUE_CANCELED_DEPENDENCY("CANCELED_DEPENDENCY"),
        VALUE_ERROR_DEPENDENCY("ERROR_DEPENDENCY"),
        VALUE_ERROR_CONFLICTS("ERROR_CONFLICTS"),
        NULL(null);

        private String value;

        private EnumStatuses(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumStatus {
        VALUE_INITIAL("INITIAL"),
        VALUE_IN_PROGRESS("IN_PROGRESS"),
        VALUE_SUCCESS("SUCCESS"),
        VALUE_ERROR("ERROR"),
        VALUE_CANCELED("CANCELED"),
        VALUE_PENDING_DEPENDENCY("PENDING_DEPENDENCY"),
        VALUE_CANCELED_DEPENDENCY("CANCELED_DEPENDENCY"),
        VALUE_ERROR_DEPENDENCY("ERROR_DEPENDENCY"),
        VALUE_ERROR_CONFLICTS("ERROR_CONFLICTS"),
        NULL(null);

        private String value;

        private EnumStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdAsyncRequest> {
        AdAsyncRequest lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"async_request_set", "created_time", "id", "input", "result", "scope_object_id", "status", "type", "updated_time"};

        @Override
        public AdAsyncRequest getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdAsyncRequest parseResponse(String response) throws APIException {
            return AdAsyncRequest.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdAsyncRequest execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdAsyncRequest execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAsyncRequestSetField() {
            return this.requestAsyncRequestSetField(true);
        }

        public APIRequestGet requestAsyncRequestSetField(boolean value) {
            this.requestField("async_request_set", value);
            return this;
        }

        public APIRequestGet requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGet requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestInputField() {
            return this.requestInputField(true);
        }

        public APIRequestGet requestInputField(boolean value) {
            this.requestField("input", value);
            return this;
        }

        public APIRequestGet requestResultField() {
            return this.requestResultField(true);
        }

        public APIRequestGet requestResultField(boolean value) {
            this.requestField("result", value);
            return this;
        }

        public APIRequestGet requestScopeObjectIdField() {
            return this.requestScopeObjectIdField(true);
        }

        public APIRequestGet requestScopeObjectIdField(boolean value) {
            this.requestField("scope_object_id", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGet requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGet requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGet requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }
    }
}

