/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdAssetFeedSpecBody;
import com.facebook.ads.sdk.AdAssetFeedSpecCaption;
import com.facebook.ads.sdk.AdAssetFeedSpecDescription;
import com.facebook.ads.sdk.AdAssetFeedSpecGroupRule;
import com.facebook.ads.sdk.AdAssetFeedSpecImage;
import com.facebook.ads.sdk.AdAssetFeedSpecLinkURL;
import com.facebook.ads.sdk.AdAssetFeedSpecTargetRule;
import com.facebook.ads.sdk.AdAssetFeedSpecTitle;
import com.facebook.ads.sdk.AdAssetFeedSpecVideo;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdAssetFeedSpec
extends APINode {
    @SerializedName(value="ad_formats")
    private List<String> mAdFormats = null;
    @SerializedName(value="bodies")
    private List<AdAssetFeedSpecBody> mBodies = null;
    @SerializedName(value="call_to_action_types")
    private List<EnumCallToActionTypes> mCallToActionTypes = null;
    @SerializedName(value="captions")
    private List<AdAssetFeedSpecCaption> mCaptions = null;
    @SerializedName(value="descriptions")
    private List<AdAssetFeedSpecDescription> mDescriptions = null;
    @SerializedName(value="groups")
    private List<AdAssetFeedSpecGroupRule> mGroups = null;
    @SerializedName(value="images")
    private List<AdAssetFeedSpecImage> mImages = null;
    @SerializedName(value="link_urls")
    private List<AdAssetFeedSpecLinkURL> mLinkUrls = null;
    @SerializedName(value="optimization_type")
    private String mOptimizationType = null;
    @SerializedName(value="target_rules")
    private List<AdAssetFeedSpecTargetRule> mTargetRules = null;
    @SerializedName(value="titles")
    private List<AdAssetFeedSpecTitle> mTitles = null;
    @SerializedName(value="videos")
    private List<AdAssetFeedSpecVideo> mVideos = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdAssetFeedSpec loadJSON(String json, APIContext context) {
        AdAssetFeedSpec adAssetFeedSpec = (AdAssetFeedSpec)AdAssetFeedSpec.getGson().fromJson(json, AdAssetFeedSpec.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adAssetFeedSpec.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adAssetFeedSpec.context = context;
        adAssetFeedSpec.rawValue = json;
        return adAssetFeedSpec;
    }

    public static APINodeList<AdAssetFeedSpec> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block18: {
            APINodeList<AdAssetFeedSpec> adAssetFeedSpecs = new APINodeList<AdAssetFeedSpec>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adAssetFeedSpecs.add(AdAssetFeedSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adAssetFeedSpecs;
                }
                if (!result.isJsonObject()) break block18;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject().get("cursors").getAsJsonObject();
                        String[] before = paging.has("before") ? paging.get("before").getAsString() : null;
                        String after = paging.has("after") ? paging.get("after").getAsString() : null;
                        adAssetFeedSpecs.setPaging((String)before, after);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adAssetFeedSpecs.add(AdAssetFeedSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adAssetFeedSpecs.add(AdAssetFeedSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adAssetFeedSpecs.add(AdAssetFeedSpec.loadJSON(obj.toString(), context));
                        }
                    }
                    return adAssetFeedSpecs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adAssetFeedSpecs.add(AdAssetFeedSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adAssetFeedSpecs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adAssetFeedSpecs.add(AdAssetFeedSpec.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adAssetFeedSpecs;
                }
                adAssetFeedSpecs.clear();
                adAssetFeedSpecs.add(AdAssetFeedSpec.loadJSON(json, context));
                return adAssetFeedSpecs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdAssetFeedSpec.getGson().toJson((Object)this);
    }

    public List<String> getFieldAdFormats() {
        return this.mAdFormats;
    }

    public AdAssetFeedSpec setFieldAdFormats(List<String> value) {
        this.mAdFormats = value;
        return this;
    }

    public List<AdAssetFeedSpecBody> getFieldBodies() {
        return this.mBodies;
    }

    public AdAssetFeedSpec setFieldBodies(List<AdAssetFeedSpecBody> value) {
        this.mBodies = value;
        return this;
    }

    public AdAssetFeedSpec setFieldBodies(String value) {
        Type type = new TypeToken<List<AdAssetFeedSpecBody>>(){}.getType();
        this.mBodies = (List)AdAssetFeedSpecBody.getGson().fromJson(value, type);
        return this;
    }

    public List<EnumCallToActionTypes> getFieldCallToActionTypes() {
        return this.mCallToActionTypes;
    }

    public AdAssetFeedSpec setFieldCallToActionTypes(List<EnumCallToActionTypes> value) {
        this.mCallToActionTypes = value;
        return this;
    }

    public List<AdAssetFeedSpecCaption> getFieldCaptions() {
        return this.mCaptions;
    }

    public AdAssetFeedSpec setFieldCaptions(List<AdAssetFeedSpecCaption> value) {
        this.mCaptions = value;
        return this;
    }

    public AdAssetFeedSpec setFieldCaptions(String value) {
        Type type = new TypeToken<List<AdAssetFeedSpecCaption>>(){}.getType();
        this.mCaptions = (List)AdAssetFeedSpecCaption.getGson().fromJson(value, type);
        return this;
    }

    public List<AdAssetFeedSpecDescription> getFieldDescriptions() {
        return this.mDescriptions;
    }

    public AdAssetFeedSpec setFieldDescriptions(List<AdAssetFeedSpecDescription> value) {
        this.mDescriptions = value;
        return this;
    }

    public AdAssetFeedSpec setFieldDescriptions(String value) {
        Type type = new TypeToken<List<AdAssetFeedSpecDescription>>(){}.getType();
        this.mDescriptions = (List)AdAssetFeedSpecDescription.getGson().fromJson(value, type);
        return this;
    }

    public List<AdAssetFeedSpecGroupRule> getFieldGroups() {
        return this.mGroups;
    }

    public AdAssetFeedSpec setFieldGroups(List<AdAssetFeedSpecGroupRule> value) {
        this.mGroups = value;
        return this;
    }

    public AdAssetFeedSpec setFieldGroups(String value) {
        Type type = new TypeToken<List<AdAssetFeedSpecGroupRule>>(){}.getType();
        this.mGroups = (List)AdAssetFeedSpecGroupRule.getGson().fromJson(value, type);
        return this;
    }

    public List<AdAssetFeedSpecImage> getFieldImages() {
        return this.mImages;
    }

    public AdAssetFeedSpec setFieldImages(List<AdAssetFeedSpecImage> value) {
        this.mImages = value;
        return this;
    }

    public AdAssetFeedSpec setFieldImages(String value) {
        Type type = new TypeToken<List<AdAssetFeedSpecImage>>(){}.getType();
        this.mImages = (List)AdAssetFeedSpecImage.getGson().fromJson(value, type);
        return this;
    }

    public List<AdAssetFeedSpecLinkURL> getFieldLinkUrls() {
        return this.mLinkUrls;
    }

    public AdAssetFeedSpec setFieldLinkUrls(List<AdAssetFeedSpecLinkURL> value) {
        this.mLinkUrls = value;
        return this;
    }

    public AdAssetFeedSpec setFieldLinkUrls(String value) {
        Type type = new TypeToken<List<AdAssetFeedSpecLinkURL>>(){}.getType();
        this.mLinkUrls = (List)AdAssetFeedSpecLinkURL.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldOptimizationType() {
        return this.mOptimizationType;
    }

    public AdAssetFeedSpec setFieldOptimizationType(String value) {
        this.mOptimizationType = value;
        return this;
    }

    public List<AdAssetFeedSpecTargetRule> getFieldTargetRules() {
        return this.mTargetRules;
    }

    public AdAssetFeedSpec setFieldTargetRules(List<AdAssetFeedSpecTargetRule> value) {
        this.mTargetRules = value;
        return this;
    }

    public AdAssetFeedSpec setFieldTargetRules(String value) {
        Type type = new TypeToken<List<AdAssetFeedSpecTargetRule>>(){}.getType();
        this.mTargetRules = (List)AdAssetFeedSpecTargetRule.getGson().fromJson(value, type);
        return this;
    }

    public List<AdAssetFeedSpecTitle> getFieldTitles() {
        return this.mTitles;
    }

    public AdAssetFeedSpec setFieldTitles(List<AdAssetFeedSpecTitle> value) {
        this.mTitles = value;
        return this;
    }

    public AdAssetFeedSpec setFieldTitles(String value) {
        Type type = new TypeToken<List<AdAssetFeedSpecTitle>>(){}.getType();
        this.mTitles = (List)AdAssetFeedSpecTitle.getGson().fromJson(value, type);
        return this;
    }

    public List<AdAssetFeedSpecVideo> getFieldVideos() {
        return this.mVideos;
    }

    public AdAssetFeedSpec setFieldVideos(List<AdAssetFeedSpecVideo> value) {
        this.mVideos = value;
        return this;
    }

    public AdAssetFeedSpec setFieldVideos(String value) {
        Type type = new TypeToken<List<AdAssetFeedSpecVideo>>(){}.getType();
        this.mVideos = (List)AdAssetFeedSpecVideo.getGson().fromJson(value, type);
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdAssetFeedSpec copyFrom(AdAssetFeedSpec instance) {
        this.mAdFormats = instance.mAdFormats;
        this.mBodies = instance.mBodies;
        this.mCallToActionTypes = instance.mCallToActionTypes;
        this.mCaptions = instance.mCaptions;
        this.mDescriptions = instance.mDescriptions;
        this.mGroups = instance.mGroups;
        this.mImages = instance.mImages;
        this.mLinkUrls = instance.mLinkUrls;
        this.mOptimizationType = instance.mOptimizationType;
        this.mTargetRules = instance.mTargetRules;
        this.mTitles = instance.mTitles;
        this.mVideos = instance.mVideos;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdAssetFeedSpec> getParser() {
        return new APIRequest.ResponseParser<AdAssetFeedSpec>(){

            @Override
            public APINodeList<AdAssetFeedSpec> parseResponse(String response, APIContext context, APIRequest<AdAssetFeedSpec> request) throws APIException.MalformedResponseException {
                return AdAssetFeedSpec.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumCallToActionTypes {
        VALUE_OPEN_LINK("OPEN_LINK"),
        VALUE_LIKE_PAGE("LIKE_PAGE"),
        VALUE_SHOP_NOW("SHOP_NOW"),
        VALUE_PLAY_GAME("PLAY_GAME"),
        VALUE_INSTALL_APP("INSTALL_APP"),
        VALUE_USE_APP("USE_APP"),
        VALUE_INSTALL_MOBILE_APP("INSTALL_MOBILE_APP"),
        VALUE_USE_MOBILE_APP("USE_MOBILE_APP"),
        VALUE_BOOK_TRAVEL("BOOK_TRAVEL"),
        VALUE_LISTEN_MUSIC("LISTEN_MUSIC"),
        VALUE_LEARN_MORE("LEARN_MORE"),
        VALUE_SIGN_UP("SIGN_UP"),
        VALUE_DOWNLOAD("DOWNLOAD"),
        VALUE_WATCH_MORE("WATCH_MORE"),
        VALUE_NO_BUTTON("NO_BUTTON"),
        VALUE_CALL_NOW("CALL_NOW"),
        VALUE_APPLY_NOW("APPLY_NOW"),
        VALUE_BUY_NOW("BUY_NOW"),
        VALUE_GET_OFFER("GET_OFFER"),
        VALUE_GET_OFFER_VIEW("GET_OFFER_VIEW"),
        VALUE_GET_DIRECTIONS("GET_DIRECTIONS"),
        VALUE_MESSAGE_PAGE("MESSAGE_PAGE"),
        VALUE_MESSAGE_USER("MESSAGE_USER"),
        VALUE_SUBSCRIBE("SUBSCRIBE"),
        VALUE_SELL_NOW("SELL_NOW"),
        VALUE_DONATE_NOW("DONATE_NOW"),
        VALUE_GET_QUOTE("GET_QUOTE"),
        VALUE_CONTACT_US("CONTACT_US"),
        VALUE_START_ORDER("START_ORDER"),
        VALUE_RECORD_NOW("RECORD_NOW"),
        VALUE_VOTE_NOW("VOTE_NOW"),
        VALUE_REGISTER_NOW("REGISTER_NOW"),
        VALUE_REQUEST_TIME("REQUEST_TIME"),
        VALUE_SEE_MENU("SEE_MENU"),
        VALUE_EMAIL_NOW("EMAIL_NOW"),
        VALUE_GET_SHOWTIMES("GET_SHOWTIMES"),
        VALUE_TRY_IT("TRY_IT"),
        VALUE_LISTEN_NOW("LISTEN_NOW"),
        VALUE_OPEN_MOVIES("OPEN_MOVIES"),
        NULL(null);

        private String value;

        private EnumCallToActionTypes(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

