/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.APIResponse;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APINodeList<T extends APINode>
extends ArrayList<T>
implements APIResponse {
    private String before;
    private String after;
    private APIRequest<T> request;
    private String rawValue;

    public APINodeList(APIRequest<T> request, String rawValue) {
        this.request = request;
        this.rawValue = rawValue;
    }

    public APINodeList<T> nextPage() throws APIException {
        return this.nextPage(0);
    }

    public APINodeList<T> nextPage(int limit) throws APIException {
        if (this.after == null) {
            return null;
        }
        HashMap<String, Object> extraParams = new HashMap<String, Object>();
        if (limit > 0) {
            extraParams.put("limit", limit);
        }
        extraParams.put("after", this.after);
        return (APINodeList)this.request.execute(extraParams);
    }

    public void setPaging(String before, String after) {
        this.before = before;
        this.after = after;
    }

    @Override
    public String getRawResponse() {
        return this.rawValue;
    }

    @Override
    public JsonObject getRawResponseAsJsonObject() {
        JsonParser parser = new JsonParser();
        return parser.parse(this.rawValue).getAsJsonObject();
    }

    public T head() {
        return (T)(this.size() > 0 ? (APINode)this.get(0) : null);
    }

    @Override
    public APIException getException() {
        return null;
    }
}

