/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.reader;

import com.exponam.core.internalColumnSegmentFilters.FilterDefinition;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class QueryColumnAttributes {
    private final boolean project;
    private final Type desiredType;
    private Optional<FilterDefinition> columnFilter;

    public QueryColumnAttributes(Type desiredType) {
        this(true, desiredType, Optional.empty());
    }

    public QueryColumnAttributes(Optional<FilterDefinition> columnFilter) {
        this(false, (Type)((Object)Object.class), Optional.empty());
    }

    public QueryColumnAttributes(Type desiredType, Optional<FilterDefinition> columnFilter) {
        this(true, desiredType, columnFilter);
    }

    public QueryColumnAttributes(boolean project, Type desiredType, Optional<FilterDefinition> columnFilter) {
        this.project = project;
        this.desiredType = this.project ? Objects.requireNonNull(desiredType, "desiredType") : Object.class;
        this.columnFilter = Objects.requireNonNull(columnFilter, "columnFilter");
    }

    public boolean getProject() {
        return this.project;
    }

    public Type getDesiredType() {
        return this.desiredType;
    }

    public Optional<FilterDefinition> getColumnFilter() {
        return this.columnFilter;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.project).append((Object)this.desiredType).append(this.columnFilter).build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryColumnAttributes)) {
            return false;
        }
        QueryColumnAttributes other = (QueryColumnAttributes)o;
        return new EqualsBuilder().append(this.project, other.project).append((Object)this.desiredType, (Object)other.desiredType).append(this.columnFilter, other.columnFilter).build();
    }

    public String toString() {
        return this.toDebugString();
    }

    private String toDebugString() {
        return String.format("project=%s, desiredType=%s, columnFilter=%s", Boolean.valueOf(this.project).toString(), this.desiredType.getTypeName(), this.columnFilter.toString());
    }
}

