/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments.times;

import com.exponam.core.ConvertForColumnType;
import com.exponam.core.internalColumnSegments.ColumnSegmentBuilderHint;
import com.exponam.core.internalColumnSegments.ColumnSegmentWithSortedValues;
import com.exponam.core.internalColumnSegments.indexes.InternalColumnSegmentIndex;
import com.exponam.core.internalColumnSegments.times.ExponamTime;
import com.exponam.core.internalColumnSegments.times.InternalTimeColumnSegmentUtilities;
import com.exponam.core.internalColumns.ColumnTypes;
import com.exponam.core.protobuf.columnsegments.ColumnSegmentBase;
import com.exponam.core.protobuf.columnsegments.ColumnSegmentIndex;
import com.exponam.core.protobuf.columnsegments.TimeWithLocalDictionaryColumnSegment;
import com.google.common.collect.Iterators;
import com.google.common.primitives.Longs;
import java.util.List;
import java.util.Map;

public class InternalTimeWithLocalDictionaryColumnSegment
extends ColumnSegmentWithSortedValues<ExponamTime, Integer> {
    private Integer[] sortedValues;
    private long[] packedIndex;
    private final int numValues;
    private InternalColumnSegmentIndex index;

    InternalTimeWithLocalDictionaryColumnSegment(int numRowsInSegment, Map<ExponamTime, List<Integer>> valuesAndRows, ColumnSegmentBuilderHint columnSegmentBuilderHint) {
        super(InternalTimeColumnSegmentUtilities.toAtRest, InternalTimeColumnSegmentUtilities.toInMemory, (TAtRest atRestValue) -> atRestValue.equals(InternalTimeColumnSegmentUtilities.Empty));
        this.numValues = numRowsInSegment;
        this.ingest(numRowsInSegment, valuesAndRows, list -> {
            this.sortedValues = list.toArray(new Integer[0]);
        }, packed -> {
            this.packedIndex = packed;
        }, columnSegmentBuilderHint, index -> {
            this.index = index;
        });
    }

    InternalTimeWithLocalDictionaryColumnSegment(TimeWithLocalDictionaryColumnSegment protoSegment) {
        super(InternalTimeColumnSegmentUtilities.toAtRest, InternalTimeColumnSegmentUtilities.toInMemory, (TAtRest atRestValue) -> atRestValue.equals(InternalTimeColumnSegmentUtilities.Empty));
        this.numValues = protoSegment.getNumValues();
        this.sortedValues = protoSegment.getIntsList().toArray(new Integer[0]);
        this.packedIndex = InternalTimeWithLocalDictionaryColumnSegment.toArray(protoSegment.getPackedIndexList());
        this.index = InternalColumnSegmentIndex.fromProto(protoSegment.getIndex());
    }

    public Integer[] sortedValues() {
        return this.sortedValues;
    }

    @Override
    protected long[] packedIndex() {
        return this.packedIndex;
    }

    @Override
    protected InternalColumnSegmentIndex index() {
        return this.index;
    }

    @Override
    protected boolean isValueEmpty(Integer value) {
        return value.equals(InternalTimeColumnSegmentUtilities.Empty);
    }

    @Override
    public String valueToString(Integer value) {
        return InternalTimeColumnSegmentUtilities.atRestToString.apply(value, this.getColumn());
    }

    @Override
    public int count() {
        return this.numValues;
    }

    @Override
    public ExponamTime marshall(Object o) {
        return (ExponamTime)ConvertForColumnType.convert(o, ColumnTypes.Time);
    }

    @Override
    public ColumnSegmentBase toProto() {
        TimeWithLocalDictionaryColumnSegment.Builder builder = TimeWithLocalDictionaryColumnSegment.newBuilder().addAllInts(() -> Iterators.forArray(this.sortedValues)).addAllPackedIndex(Longs.asList(this.packedIndex)).setNumValues(this.numValues);
        ColumnSegmentIndex protoIndex = InternalColumnSegmentIndex.toProto(this.index);
        if (protoIndex != null) {
            builder.setIndex(protoIndex);
        }
        TimeWithLocalDictionaryColumnSegment protoSegment = builder.build();
        return ColumnSegmentBase.newBuilder().mergeTimeWithLocalDictionaryColumnSegment(protoSegment).build();
    }
}

