/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments.times;

import com.exponam.core.internalColumnSegments.times.InternalTimeColumnSegmentUtilities;
import java.io.Serializable;
import java.sql.Time;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Date;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ExponamTime
implements Serializable,
Comparable<ExponamTime> {
    private final int timeOfDayInMillis;

    public ExponamTime(int timeOfDayInMillis) {
        this.timeOfDayInMillis = timeOfDayInMillis;
    }

    public static ExponamTime fromDate(Date date) {
        long l = date.getTime();
        return new ExponamTime((int)l);
    }

    public int getTimeOfDayInMillis() {
        return this.timeOfDayInMillis;
    }

    public Time toSqlTime() {
        if (this.timeOfDayInMillis == InternalTimeColumnSegmentUtilities.Empty) {
            return new Time(-1L);
        }
        Instant dateInstant = Instant.ofEpochMilli(this.timeOfDayInMillis);
        ZoneOffset zoneOffset = ZoneId.systemDefault().getRules().getOffset(dateInstant);
        int totalSeconds = zoneOffset.getTotalSeconds();
        long timeAdjustedForTimeZone = (long)this.timeOfDayInMillis - (long)totalSeconds * 1000L;
        return new Time(timeAdjustedForTimeZone);
    }

    @Override
    public int compareTo(ExponamTime o) {
        return Integer.compare(this.timeOfDayInMillis, o.getTimeOfDayInMillis());
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.timeOfDayInMillis).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExponamTime)) {
            return false;
        }
        ExponamTime other = (ExponamTime)o;
        return this.timeOfDayInMillis == other.getTimeOfDayInMillis();
    }

    public String toString() {
        return this.toDebugString();
    }

    private String toDebugString() {
        if (this.timeOfDayInMillis == InternalTimeColumnSegmentUtilities.Empty) {
            return "-";
        }
        return this.toSqlTime().toString();
    }
}

