/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments.strings;

import com.exponam.core.ConvertForColumnType;
import com.exponam.core.internalColumnSegments.ColumnSegmentWithRowOrderValues;
import com.exponam.core.internalColumns.ColumnTypes;
import com.exponam.core.protobuf.columnsegments.ColumnSegmentBase;
import com.exponam.core.protobuf.columnsegments.StringWithRowOrderDataColumnSegment;
import com.google.common.collect.Iterators;
import com.google.protobuf.ByteString;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class InternalStringWithRowOrderDataColumnSegment
extends ColumnSegmentWithRowOrderValues<String, String> {
    private final int numValues;
    private String minValue;
    private String maxValue;
    private boolean emptyExists;
    private String[] rowOrderValues;

    InternalStringWithRowOrderDataColumnSegment(int numRowsInSegment, Map<String, List<Integer>> valuesAndRows) {
        super(s2 -> s2, (TAtRest s2) -> s2);
        this.numValues = numRowsInSegment;
        this.ingest(numRowsInSegment, valuesAndRows, rowOrderValues -> {
            this.rowOrderValues = rowOrderValues;
        }, min2 -> {
            this.minValue = min2;
        }, max -> {
            this.maxValue = max;
        }, empty -> {
            this.emptyExists = empty;
        }, String.class);
    }

    InternalStringWithRowOrderDataColumnSegment(StringWithRowOrderDataColumnSegment protoSegment) {
        super(s2 -> s2, (TAtRest s2) -> s2);
        this.numValues = protoSegment.getNumValues();
        this.minValue = protoSegment.getMinValue();
        this.maxValue = protoSegment.getMaxValue();
        this.emptyExists = protoSegment.getEmptyExists();
        this.rowOrderValues = (String[])protoSegment.getRowOrderValuesList().toArray((Object[])new String[0]);
    }

    protected String[] rowOrderValues() {
        return this.rowOrderValues;
    }

    @Override
    protected boolean isValueEmpty(String value) {
        return false;
    }

    @Override
    protected String valueToString(String value) {
        return value;
    }

    @Override
    public int count() {
        return this.numValues;
    }

    @Override
    public Optional<String> getMinValue() {
        return Optional.of(this.minValue);
    }

    @Override
    public Optional<String> getMaxValue() {
        return Optional.of(this.maxValue);
    }

    @Override
    public boolean getEmptyExists() {
        return this.emptyExists;
    }

    @Override
    public String marshall(Object o) {
        return (String)ConvertForColumnType.convert(o, ColumnTypes.String);
    }

    @Override
    public ColumnSegmentBase toProto() {
        StringWithRowOrderDataColumnSegment.Builder builder = StringWithRowOrderDataColumnSegment.newBuilder().setNumValues(this.numValues).setMinValue(this.minValue).setMaxValue(this.maxValue).setEmptyExists(this.emptyExists);
        Iterators.forArray(this.rowOrderValues).forEachRemaining(s2 -> builder.addRowOrderValuesBytes(ByteString.copyFrom((byte[])s2.getBytes(StandardCharsets.UTF_8))));
        StringWithRowOrderDataColumnSegment protoSegment = builder.build();
        return ColumnSegmentBase.newBuilder().mergeStringWithRowOrderDataColumnSegment(protoSegment).build();
    }
}

