/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments.strings;

import com.exponam.core.ConvertForColumnType;
import com.exponam.core.internalColumnSegments.ColumnSegmentBuilderHint;
import com.exponam.core.internalColumnSegments.ColumnSegmentWithSortedValues;
import com.exponam.core.internalColumnSegments.indexes.InternalColumnSegmentIndex;
import com.exponam.core.internalColumns.ColumnTypes;
import com.exponam.core.protobuf.columnsegments.ColumnSegmentBase;
import com.exponam.core.protobuf.columnsegments.ColumnSegmentIndex;
import com.exponam.core.protobuf.columnsegments.StringWithLocalDictionaryColumnSegment;
import com.google.common.collect.Iterators;
import com.google.common.primitives.Longs;
import com.google.protobuf.ByteString;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

public final class InternalStringWithLocalDictionaryColumnSegment
extends ColumnSegmentWithSortedValues<String, String> {
    private String[] sortedValues;
    private long[] packedIndex;
    private int numValues;
    private InternalColumnSegmentIndex index;

    InternalStringWithLocalDictionaryColumnSegment(int numRowsInSegment, Map<String, List<Integer>> valuesAndRows, ColumnSegmentBuilderHint columnSegmentBuilderHint) {
        super(s2 -> s2, (TAtRest s2) -> s2, (TAtRest atRestString) -> false);
        this.numValues = numRowsInSegment;
        this.ingest(numRowsInSegment, valuesAndRows, list -> {
            this.sortedValues = list.toArray(new String[0]);
        }, packed -> {
            this.packedIndex = packed;
        }, columnSegmentBuilderHint, index -> {
            this.index = index;
        });
    }

    InternalStringWithLocalDictionaryColumnSegment(StringWithLocalDictionaryColumnSegment protoSegment) {
        super(s2 -> s2, (TAtRest s2) -> s2, (TAtRest atRestString) -> false);
        this.numValues = protoSegment.getNumValues();
        this.sortedValues = (String[])protoSegment.getSortedValuesList().toArray((Object[])new String[0]);
        this.packedIndex = InternalStringWithLocalDictionaryColumnSegment.toArray(protoSegment.getPackedIndexList());
        this.index = InternalColumnSegmentIndex.fromProto(protoSegment.getIndex());
    }

    public String[] sortedValues() {
        return this.sortedValues;
    }

    @Override
    protected long[] packedIndex() {
        return this.packedIndex;
    }

    @Override
    protected InternalColumnSegmentIndex index() {
        return this.index;
    }

    @Override
    protected boolean isValueEmpty(String value) {
        return false;
    }

    @Override
    public String valueToString(String value) {
        return value;
    }

    @Override
    public int count() {
        return this.numValues;
    }

    @Override
    public String marshall(Object o) {
        return (String)ConvertForColumnType.convert(o, ColumnTypes.String);
    }

    @Override
    public ColumnSegmentBase toProto() {
        StringWithLocalDictionaryColumnSegment.Builder builder = StringWithLocalDictionaryColumnSegment.newBuilder().addAllPackedIndex(Longs.asList(this.packedIndex)).setNumValues(this.numValues);
        Iterators.forArray(this.sortedValues).forEachRemaining(s2 -> builder.addSortedValuesBytes(ByteString.copyFrom((byte[])s2.getBytes(StandardCharsets.UTF_8))));
        ColumnSegmentIndex protoIndex = InternalColumnSegmentIndex.toProto(this.index);
        if (protoIndex != null) {
            builder.setIndex(protoIndex);
        }
        StringWithLocalDictionaryColumnSegment protoSegment = builder.build();
        return ColumnSegmentBase.newBuilder().mergeStringWithLocalDictionaryColumnSegment(protoSegment).build();
    }
}

