/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments.longs;

import com.exponam.core.ConvertForColumnType;
import com.exponam.core.internalColumnSegments.ColumnSegmentWithOneValue;
import com.exponam.core.internalColumnSegments.longs.InternalLongColumnSegmentUtilities;
import com.exponam.core.internalColumns.ColumnTypes;
import com.exponam.core.protobuf.columnsegments.ColumnSegmentBase;
import com.exponam.core.protobuf.columnsegments.LongWithOneValueColumnSegment;

public class InternalLongWithOneValueColumnSegment
extends ColumnSegmentWithOneValue<Long, Long> {
    private final Long singleValue;
    private final int numValues;

    InternalLongWithOneValueColumnSegment(long singleValue, int numValues) {
        this.singleValue = singleValue;
        this.numValues = numValues;
    }

    InternalLongWithOneValueColumnSegment(LongWithOneValueColumnSegment protoSegment) {
        this.singleValue = protoSegment.getSingleValue();
        this.numValues = protoSegment.getNumValues();
    }

    @Override
    protected Long singleValueAtRest() {
        return this.singleValue;
    }

    @Override
    protected Long singleValue() {
        return this.singleValue;
    }

    @Override
    public boolean isSingleValueEmpty() {
        return this.singleValue.equals(InternalLongColumnSegmentUtilities.Empty);
    }

    @Override
    protected String singleValueToString() {
        return InternalLongColumnSegmentUtilities.atRestToString.apply(this.singleValue, this.getColumn());
    }

    @Override
    public int count() {
        return this.numValues;
    }

    @Override
    public Long marshall(Object o) {
        return (Long)ConvertForColumnType.convert(o, ColumnTypes.Long);
    }

    @Override
    public ColumnSegmentBase toProto() {
        LongWithOneValueColumnSegment protoSegment = LongWithOneValueColumnSegment.newBuilder().setSingleValue(this.singleValue).setNumValues(this.numValues).build();
        return ColumnSegmentBase.newBuilder().mergeLongWithOneValueColumnSegment(protoSegment).build();
    }
}

