/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments.longs;

import com.exponam.core.ConvertForColumnType;
import com.exponam.core.internalColumnSegments.ColumnSegmentBuilderHint;
import com.exponam.core.internalColumnSegments.ColumnSegmentWithSortedValues;
import com.exponam.core.internalColumnSegments.indexes.InternalColumnSegmentIndex;
import com.exponam.core.internalColumnSegments.longs.InternalLongColumnSegmentUtilities;
import com.exponam.core.internalColumns.ColumnTypes;
import com.exponam.core.protobuf.columnsegments.ColumnSegmentBase;
import com.exponam.core.protobuf.columnsegments.ColumnSegmentIndex;
import com.exponam.core.protobuf.columnsegments.LongWithLocalDictionaryColumnSegment;
import com.google.common.collect.Iterators;
import com.google.common.primitives.Longs;
import java.util.List;
import java.util.Map;

public class InternalLongWithLocalDictionaryColumnSegment
extends ColumnSegmentWithSortedValues<Long, Long> {
    private Long[] sortedValues;
    private long[] packedIndex;
    private int numValues;
    private InternalColumnSegmentIndex index;

    InternalLongWithLocalDictionaryColumnSegment(int numRowsInSegment, Map<Long, List<Integer>> valuesAndRows, ColumnSegmentBuilderHint columnSegmentBuilderHint) {
        super(l -> l, (TAtRest l) -> l, (TAtRest atRestValue) -> atRestValue.equals(InternalLongColumnSegmentUtilities.Empty));
        this.numValues = numRowsInSegment;
        this.ingest(numRowsInSegment, valuesAndRows, list -> {
            this.sortedValues = list.toArray(new Long[0]);
        }, packed -> {
            this.packedIndex = packed;
        }, columnSegmentBuilderHint, index -> {
            this.index = index;
        });
    }

    InternalLongWithLocalDictionaryColumnSegment(LongWithLocalDictionaryColumnSegment protoSegment) {
        super(l -> l, (TAtRest l) -> l, (TAtRest atRestValue) -> atRestValue.equals(InternalLongColumnSegmentUtilities.Empty));
        this.numValues = protoSegment.getNumValues();
        this.sortedValues = protoSegment.getLongsList().toArray(new Long[0]);
        this.packedIndex = InternalLongWithLocalDictionaryColumnSegment.toArray(protoSegment.getPackedIndexList());
        this.index = InternalColumnSegmentIndex.fromProto(protoSegment.getIndex());
    }

    public Long[] sortedValues() {
        return this.sortedValues;
    }

    @Override
    protected long[] packedIndex() {
        return this.packedIndex;
    }

    @Override
    protected InternalColumnSegmentIndex index() {
        return this.index;
    }

    @Override
    protected boolean isValueEmpty(Long value) {
        return value.equals(InternalLongColumnSegmentUtilities.Empty);
    }

    @Override
    public String valueToString(Long value) {
        return InternalLongColumnSegmentUtilities.atRestToString.apply(value, this.getColumn());
    }

    @Override
    public int count() {
        return this.numValues;
    }

    @Override
    public Long marshall(Object o) {
        return (Long)ConvertForColumnType.convert(o, ColumnTypes.Long);
    }

    @Override
    public ColumnSegmentBase toProto() {
        LongWithLocalDictionaryColumnSegment.Builder builder = LongWithLocalDictionaryColumnSegment.newBuilder().addAllLongs(() -> Iterators.forArray(this.sortedValues)).addAllPackedIndex(Longs.asList(this.packedIndex)).setNumValues(this.numValues);
        ColumnSegmentIndex protoIndex = InternalColumnSegmentIndex.toProto(this.index);
        if (protoIndex != null) {
            builder.setIndex(protoIndex);
        }
        LongWithLocalDictionaryColumnSegment protoSegment = builder.build();
        return ColumnSegmentBase.newBuilder().mergeLongWithLocalDictionaryColumnSegment(protoSegment).build();
    }
}

