/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments.indexes;

import com.exponam.core.ImmutablePair;
import com.exponam.core.internalColumnSegments.indexes.IndexCost;
import com.exponam.core.internalColumnSegments.indexes.InternalColumnSegmentIndex;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class SortedIndexWithJumpTable {
    public static <TInMemory> ImmutablePair<InternalColumnSegmentIndex, IndexCost> buildFrom(int numRows, List<TInMemory> sortedNativeValues, Map<TInMemory, List<Integer>> valuesAndRows) {
        short[] combinedJumpTableAndSortedRows = new short[sortedNativeValues.size() + numRows];
        int sortedRowIndex = sortedNativeValues.size();
        for (int i = 0; i < sortedNativeValues.size(); ++i) {
            combinedJumpTableAndSortedRows[i] = (short)sortedRowIndex;
            List<Integer> rows = valuesAndRows.get(sortedNativeValues.get(i));
            for (int j = 0; j < rows.size(); ++j) {
                short row = (short)rows.get(j).intValue();
                combinedJumpTableAndSortedRows[sortedRowIndex++] = row;
            }
        }
        return ImmutablePair.of(new InternalColumnSegmentIndex(2, combinedJumpTableAndSortedRows), new IndexCost(combinedJumpTableAndSortedRows.length));
    }

    static void forRowsForElementDo(int jumpTableIndex, int jumpTableSize, short[] combinedJumpTableAndSortedRows, Consumer<Integer> doForRow) {
        int offestToSortedIndex = combinedJumpTableAndSortedRows[jumpTableIndex];
        int stopAt = jumpTableIndex == jumpTableSize - 1 ? combinedJumpTableAndSortedRows.length : combinedJumpTableAndSortedRows[jumpTableIndex + 1];
        for (int i = offestToSortedIndex; i < stopAt; ++i) {
            short row = combinedJumpTableAndSortedRows[i];
            doForRow.accept(Integer.valueOf(row));
        }
    }
}

