/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments.doubles;

import com.exponam.core.ConvertForColumnType;
import com.exponam.core.internalColumnSegments.ColumnSegmentWithRowOrderValues;
import com.exponam.core.internalColumnSegments.doubles.InternalDoubleColumnSegmentUtilities;
import com.exponam.core.internalColumns.ColumnTypes;
import com.exponam.core.protobuf.columnsegments.ColumnSegmentBase;
import com.exponam.core.protobuf.columnsegments.DoubleWithRowOrderDataColumnSegment;
import com.google.common.collect.Iterators;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class InternalDoubleWithRowOrderDataColumnSegment
extends ColumnSegmentWithRowOrderValues<Double, Double> {
    private final int numValues;
    private Double minValue;
    private Double maxValue;
    private boolean emptyExists;
    private Double[] rowOrderValues;

    InternalDoubleWithRowOrderDataColumnSegment(int numRowsInSegment, Map<Double, List<Integer>> valuesAndRows) {
        super(l -> l, (TAtRest l) -> l);
        this.numValues = numRowsInSegment;
        this.ingest(numRowsInSegment, valuesAndRows, rowOrderValues -> {
            this.rowOrderValues = rowOrderValues;
        }, min2 -> {
            this.minValue = min2;
        }, max -> {
            this.maxValue = max;
        }, empty -> {
            this.emptyExists = empty;
        }, Double.class);
    }

    InternalDoubleWithRowOrderDataColumnSegment(DoubleWithRowOrderDataColumnSegment protoSegment) {
        super(s2 -> s2, (TAtRest s2) -> s2);
        this.numValues = protoSegment.getNumValues();
        this.minValue = protoSegment.getMinValue();
        this.maxValue = protoSegment.getMaxValue();
        this.emptyExists = protoSegment.getEmptyExists();
        this.rowOrderValues = protoSegment.getRowOrderValuesList().toArray(new Double[0]);
    }

    protected Double[] rowOrderValues() {
        return this.rowOrderValues;
    }

    @Override
    protected boolean isValueEmpty(Double value) {
        return value.equals(InternalDoubleColumnSegmentUtilities.Empty);
    }

    @Override
    protected String valueToString(Double value) {
        return InternalDoubleColumnSegmentUtilities.atRestToString.apply(value, this.getColumn());
    }

    @Override
    public int count() {
        return this.numValues;
    }

    @Override
    public Optional<Double> getMinValue() {
        return Optional.of(this.minValue);
    }

    @Override
    public Optional<Double> getMaxValue() {
        return Optional.of(this.maxValue);
    }

    @Override
    public boolean getEmptyExists() {
        return this.emptyExists;
    }

    @Override
    public Double marshall(Object o) {
        return (Double)ConvertForColumnType.convert(o, ColumnTypes.Double);
    }

    @Override
    public ColumnSegmentBase toProto() {
        DoubleWithRowOrderDataColumnSegment protoSegment = DoubleWithRowOrderDataColumnSegment.newBuilder().setNumValues(this.numValues).setMinValue(this.minValue).setMaxValue(this.maxValue).setEmptyExists(this.emptyExists).addAllRowOrderValues(() -> Iterators.forArray(this.rowOrderValues)).build();
        return ColumnSegmentBase.newBuilder().mergeDoubleWithRowOrderDataColumnSegment(protoSegment).build();
    }
}

