/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments.dates;

import com.exponam.core.ConvertForColumnType;
import com.exponam.core.internalColumnSegments.ColumnSegmentBuilderHint;
import com.exponam.core.internalColumnSegments.ColumnSegmentWithSortedValues;
import com.exponam.core.internalColumnSegments.dates.InternalDateColumnSegmentUtilities;
import com.exponam.core.internalColumnSegments.indexes.InternalColumnSegmentIndex;
import com.exponam.core.internalColumns.ColumnTypes;
import com.exponam.core.protobuf.columnsegments.ColumnSegmentBase;
import com.exponam.core.protobuf.columnsegments.ColumnSegmentIndex;
import com.exponam.core.protobuf.columnsegments.DateWithLocalDictionaryColumnSegment;
import com.google.common.collect.Iterators;
import com.google.common.primitives.Longs;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class InternalDateWithLocalDictionaryColumnSegment
extends ColumnSegmentWithSortedValues<Date, Integer> {
    private Integer[] sortedValues;
    private long[] packedIndex;
    private int numValues;
    private InternalColumnSegmentIndex index;

    InternalDateWithLocalDictionaryColumnSegment(int numRowsInSegment, Map<Date, List<Integer>> valuesAndRows, ColumnSegmentBuilderHint columnSegmentBuilderHint) {
        super(InternalDateColumnSegmentUtilities.toAtRest, InternalDateColumnSegmentUtilities.toInMemory, (TAtRest atRestValue) -> atRestValue.equals(InternalDateColumnSegmentUtilities.Empty));
        this.numValues = numRowsInSegment;
        this.ingest(numRowsInSegment, valuesAndRows, list -> {
            this.sortedValues = list.toArray(new Integer[0]);
        }, packed -> {
            this.packedIndex = packed;
        }, columnSegmentBuilderHint, index -> {
            this.index = index;
        });
    }

    InternalDateWithLocalDictionaryColumnSegment(DateWithLocalDictionaryColumnSegment protoSegment) {
        super(InternalDateColumnSegmentUtilities.toAtRest, InternalDateColumnSegmentUtilities.toInMemory, (TAtRest atRestValue) -> atRestValue.equals(InternalDateColumnSegmentUtilities.Empty));
        this.numValues = protoSegment.getNumValues();
        this.sortedValues = protoSegment.getDaysList().toArray(new Integer[0]);
        this.packedIndex = InternalDateWithLocalDictionaryColumnSegment.toArray(protoSegment.getPackedIndexList());
        this.index = InternalColumnSegmentIndex.fromProto(protoSegment.getIndex());
    }

    public Integer[] sortedValues() {
        return this.sortedValues;
    }

    @Override
    protected long[] packedIndex() {
        return this.packedIndex;
    }

    @Override
    protected InternalColumnSegmentIndex index() {
        return this.index;
    }

    @Override
    protected boolean isValueEmpty(Integer value) {
        return value.equals(InternalDateColumnSegmentUtilities.Empty);
    }

    @Override
    public String valueToString(Integer value) {
        return InternalDateColumnSegmentUtilities.atRestToString.apply(value, this.getColumn());
    }

    @Override
    public int count() {
        return this.numValues;
    }

    @Override
    public Date marshall(Object o) {
        return (Date)ConvertForColumnType.convert(o, ColumnTypes.DateTime);
    }

    @Override
    public ColumnSegmentBase toProto() {
        DateWithLocalDictionaryColumnSegment.Builder builder = DateWithLocalDictionaryColumnSegment.newBuilder().addAllDays(() -> Iterators.forArray(this.sortedValues)).addAllPackedIndex(Longs.asList(this.packedIndex)).setNumValues(this.numValues);
        ColumnSegmentIndex protoIndex = InternalColumnSegmentIndex.toProto(this.index);
        if (protoIndex != null) {
            builder.setIndex(protoIndex);
        }
        DateWithLocalDictionaryColumnSegment protoSegment = builder.build();
        return ColumnSegmentBase.newBuilder().mergeDateWithLocalDictionaryColumnSegment(protoSegment).build();
    }
}

