/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments;

import com.exponam.core.internalColumnSegmentFilterResult.BitArray;
import com.exponam.core.internalColumnSegmentFilterResult.IBitArray;
import com.exponam.core.internalColumnSegmentFilters.ApplyComparisonFilterToSortedValuesColumnSegment;
import com.exponam.core.internalColumnSegmentFilters.ApplyNullityFilterToSortedValuesColumnSegment;
import com.exponam.core.internalColumnSegmentFilters.ApplyStringFilterToSortedValuesColumnSegment;
import com.exponam.core.internalColumnSegmentFilters.ComparisonFilter;
import com.exponam.core.internalColumnSegmentFilters.InternalColumnSegmentFilterBase;
import com.exponam.core.internalColumnSegmentFilters.NullityFilter;
import com.exponam.core.internalColumnSegmentFilters.StringFilter;
import com.exponam.core.internalColumnSegments.ColumnSegmentBuilderHint;
import com.exponam.core.internalColumnSegments.ColumnSegmentIndexBuilder;
import com.exponam.core.internalColumnSegments.IndexedValuesBitFieldPacker;
import com.exponam.core.internalColumnSegments.InternalColumnSegmentBase;
import com.exponam.core.internalColumnSegments.indexes.InternalColumnSegmentIndex;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;

public abstract class ColumnSegmentWithSortedValues<TInMemory extends Comparable<? super TInMemory>, TAtRest extends Comparable<TAtRest>>
extends InternalColumnSegmentBase<TInMemory, TAtRest> {
    private final Function<TInMemory, TAtRest> convertToAtRest;
    private final Function<TAtRest, TInMemory> convertToInMemory;
    private final Function<TAtRest, Boolean> isEmpty;
    private IndexedValuesBitFieldPacker bitFieldPacker;

    protected ColumnSegmentWithSortedValues(Function<TInMemory, TAtRest> convertToAtRest, Function<TAtRest, TInMemory> convertToInMemory, Function<TAtRest, Boolean> isEmpty) {
        this.convertToAtRest = convertToAtRest;
        this.convertToInMemory = convertToInMemory;
        this.isEmpty = isEmpty;
    }

    protected void ingest(int numRowsInSegment, Map<TInMemory, List<Integer>> valuesAndRows, Consumer<List<TAtRest>> sortedValuesSetterConsumer, Consumer<long[]> packedIndexSetterConsumer, ColumnSegmentBuilderHint columnSegmentBuilderHint, Consumer<InternalColumnSegmentIndex> columnSegmentIndexConsumer) {
        List sortedNativeValues = valuesAndRows.keySet().stream().sorted().collect(Collectors.toList());
        List sortedAtRestValues = sortedNativeValues.stream().map(this.convertToAtRest).collect(Collectors.toList());
        long[] packedIndex = IndexedValuesBitFieldPacker.packedEntries(sortedAtRestValues.size() - 1, numRowsInSegment);
        IndexedValuesBitFieldPacker bitFieldPacker = new IndexedValuesBitFieldPacker(packedIndex, sortedAtRestValues.size() - 1);
        int rowsWithEntryValues = 0;
        for (int indexInSortedValues = 0; indexInSortedValues < sortedAtRestValues.size(); ++indexInSortedValues) {
            List<Integer> rowsForSortedValue = valuesAndRows.get(sortedNativeValues.get(indexInSortedValues));
            for (Integer row : rowsForSortedValue) {
                bitFieldPacker.putValueForEntry(row, indexInSortedValues);
                ++rowsWithEntryValues;
            }
        }
        if (rowsWithEntryValues != numRowsInSegment) {
            throw new IllegalArgumentException("wrong number of rows ingested");
        }
        InternalColumnSegmentIndex internalColumnSegmentIndex = ColumnSegmentIndexBuilder.buildFrom(numRowsInSegment, sortedNativeValues, valuesAndRows, bitFieldPacker, columnSegmentBuilderHint);
        sortedValuesSetterConsumer.accept(sortedAtRestValues);
        packedIndexSetterConsumer.accept(packedIndex);
        columnSegmentIndexConsumer.accept(internalColumnSegmentIndex);
    }

    public Function<TAtRest, TInMemory> convertToInMemory() {
        return this.convertToInMemory;
    }

    public abstract TAtRest[] sortedValues();

    protected abstract long[] packedIndex();

    protected abstract InternalColumnSegmentIndex index();

    protected abstract boolean isValueEmpty(TAtRest var1);

    public abstract String valueToString(TAtRest var1);

    protected TAtRest get(int index) {
        int indexInSortedValues = this.getBitFieldPacker().getValueForEntry(index);
        if (indexInSortedValues < 0 || indexInSortedValues > this.sortedValues().length - 1) {
            throw new IllegalArgumentException("indexInSortedValues out of range");
        }
        return (TAtRest)this.sortedValues()[indexInSortedValues];
    }

    private IndexedValuesBitFieldPacker getBitFieldPacker() {
        if (this.bitFieldPacker != null) {
            return this.bitFieldPacker;
        }
        this.bitFieldPacker = new IndexedValuesBitFieldPacker(this.packedIndex(), this.sortedValues().length - 1);
        return this.bitFieldPacker;
    }

    @Override
    public TAtRest atRestValueForIndex(int index) {
        return this.get(index);
    }

    @Override
    public TInMemory inMemoryValueForIndex(int index) {
        return (TInMemory)((Comparable)this.convertToInMemory.apply(this.get(index)));
    }

    @Override
    public String stringValueForIndex(int index) {
        return this.valueToString(this.get(index));
    }

    public void doForSpecificSortedItemsIndexes(int sortedItemIndexFrom, int sortedItemIndexToInclusive, Consumer<Integer> doForRow) {
        InternalColumnSegmentIndex internalColumnSegmentIndex = this.index();
        if (internalColumnSegmentIndex != null && internalColumnSegmentIndex.getIndexType() != 0) {
            for (int sortedItemIndex = sortedItemIndexFrom; sortedItemIndex <= sortedItemIndexToInclusive; ++sortedItemIndex) {
                internalColumnSegmentIndex.forRowsForElementDo(sortedItemIndex, this.sortedValues().length, this.getBitFieldPacker(), doForRow);
            }
            return;
        }
        for (int i = 0; i < this.count(); ++i) {
            long indexInSortedValues = this.getBitFieldPacker().getValueForEntry(i);
            if (indexInSortedValues < (long)sortedItemIndexFrom || indexInSortedValues > (long)sortedItemIndexToInclusive) continue;
            doForRow.accept(i);
        }
    }

    public void doForSpecificSortedItemIndex(int sortedItemIndex, Consumer<Integer> doForRow) {
        InternalColumnSegmentIndex internalColumnSegmentIndex = this.index();
        if (internalColumnSegmentIndex != null && internalColumnSegmentIndex.getIndexType() != 0) {
            internalColumnSegmentIndex.forRowsForElementDo(sortedItemIndex, this.sortedValues().length, this.getBitFieldPacker(), doForRow);
            return;
        }
        for (int i = 0; i < this.count(); ++i) {
            int indexInSortedValues = this.getBitFieldPacker().getValueForEntry(i);
            if (indexInSortedValues != sortedItemIndex) continue;
            doForRow.accept(i);
        }
    }

    @Override
    public IBitArray applyFilter(InternalColumnSegmentFilterBase filter) {
        BitArray rowLevelResults = new BitArray(this.count());
        InternalColumnSegmentIndex internalColumnSegmentIndex = this.index();
        if (internalColumnSegmentIndex != null) {
            for (int i = 0; i < this.sortedValues().length; ++i) {
                if (!filter.passesFilter(this.sortedValues()[i])) continue;
                internalColumnSegmentIndex.forRowsForElementDo(i, this.sortedValues().length, this.getBitFieldPacker(), row -> rowLevelResults.set((int)row, true));
            }
            return rowLevelResults.toReadOnly();
        }
        if (this.sortedValues().length <= 64) {
            int i;
            long bitFieldForMatchingSortedValues = 0L;
            for (i = 0; i < this.sortedValues().length; ++i) {
                if (!filter.passesFilter(this.sortedValues()[i])) continue;
                bitFieldForMatchingSortedValues |= 1L << i;
            }
            for (i = 0; i < this.count(); ++i) {
                int indexInSortedValues = this.getBitFieldPacker().getValueForEntry(i);
                long bitFieldForSpecificSortedValueValue = 1L << indexInSortedValues;
                if ((bitFieldForMatchingSortedValues & bitFieldForSpecificSortedValueValue) == 0L) continue;
                rowLevelResults.set(i, true);
            }
            return rowLevelResults.toReadOnly();
        }
        for (int i = 0; i < this.count(); ++i) {
            if (!filter.passesFilter(this.get(i))) continue;
            rowLevelResults.set(i, true);
        }
        return rowLevelResults.toReadOnly();
    }

    @Override
    protected ComparisonFilter<TInMemory, TAtRest> createComparisonFilter() {
        return new ApplyComparisonFilterToSortedValuesColumnSegment(this);
    }

    @Override
    protected NullityFilter<TInMemory, TAtRest> createNullityFilter() {
        return new ApplyNullityFilterToSortedValuesColumnSegment(this);
    }

    @Override
    protected StringFilter<TInMemory, TAtRest> createStringFilter() {
        return new ApplyStringFilterToSortedValuesColumnSegment(this);
    }

    @Override
    public final Optional<TInMemory> getMinValue() {
        int minValueIndex = this.getEmptyExists() ? 1 : 0;
        return Optional.of(this.convertToInMemory.apply(this.sortedValues()[minValueIndex]));
    }

    @Override
    public final Optional<TInMemory> getMaxValue() {
        int maxValueIndex = this.sortedValues().length - 1;
        return Optional.of(this.convertToInMemory.apply(this.sortedValues()[maxValueIndex]));
    }

    @Override
    public final boolean getEmptyExists() {
        return this.isEmpty.apply(this.sortedValues()[0]);
    }

    protected static long[] toArray(List<Long> longList) {
        long[] result = new long[longList.size()];
        for (int i = 0; i < longList.size(); ++i) {
            result[i] = longList.get(i);
        }
        return result;
    }

    protected static long[] toArray(Long[] longList) {
        long[] result = new long[longList.length];
        for (int i = 0; i < longList.length; ++i) {
            result[i] = longList[i];
        }
        return result;
    }

    public int hashCode() {
        return Arrays.hashCode(this.sortedValues());
    }

    public boolean equals(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        if (other == this) {
            return true;
        }
        ColumnSegmentWithSortedValues otherColumnSegment = (ColumnSegmentWithSortedValues)other;
        return new EqualsBuilder().append(this.packedIndex(), otherColumnSegment.packedIndex()).append((Object[])this.sortedValues(), (Object[])otherColumnSegment.sortedValues()).isEquals();
    }
}

