/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments;

import com.exponam.core.internalColumnSegmentFilterResult.AllFalseBitArray;
import com.exponam.core.internalColumnSegmentFilterResult.AllTrueBitArray;
import com.exponam.core.internalColumnSegmentFilterResult.IBitArray;
import com.exponam.core.internalColumnSegmentFilters.ApplyComparisonFilterToOneValueColumnSegment;
import com.exponam.core.internalColumnSegmentFilters.ApplyNullityFilterToOneValueColumnSegment;
import com.exponam.core.internalColumnSegmentFilters.ApplyStringFilterToOneValueColumnSegment;
import com.exponam.core.internalColumnSegmentFilters.ComparisonFilter;
import com.exponam.core.internalColumnSegmentFilters.InternalColumnSegmentFilterBase;
import com.exponam.core.internalColumnSegmentFilters.NullityFilter;
import com.exponam.core.internalColumnSegmentFilters.StringFilter;
import com.exponam.core.internalColumnSegments.InternalColumnSegmentBase;
import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public abstract class ColumnSegmentWithOneValue<TInMemory extends Comparable<? super TInMemory>, TAtRest extends Comparable<TAtRest>>
extends InternalColumnSegmentBase<TInMemory, TAtRest> {
    protected abstract TAtRest singleValueAtRest();

    protected abstract TInMemory singleValue();

    public abstract boolean isSingleValueEmpty();

    protected abstract String singleValueToString();

    @Override
    public TAtRest atRestValueForIndex(int index) {
        return this.singleValueAtRest();
    }

    @Override
    public TInMemory inMemoryValueForIndex(int index) {
        return this.singleValue();
    }

    @Override
    public String stringValueForIndex(int index) {
        return this.singleValueToString();
    }

    @Override
    public IBitArray applyFilter(InternalColumnSegmentFilterBase filter) {
        return filter.passesFilter(this.singleValue()) ? new AllTrueBitArray(this.count()).toReadOnly() : new AllFalseBitArray(this.count()).toReadOnly();
    }

    @Override
    protected ComparisonFilter<TInMemory, TAtRest> createComparisonFilter() {
        return new ApplyComparisonFilterToOneValueColumnSegment(this);
    }

    @Override
    protected NullityFilter<TInMemory, TAtRest> createNullityFilter() {
        return new ApplyNullityFilterToOneValueColumnSegment(this);
    }

    @Override
    protected StringFilter<TInMemory, TAtRest> createStringFilter() {
        return new ApplyStringFilterToOneValueColumnSegment(this);
    }

    @Override
    public final Optional<TInMemory> getMinValue() {
        return this.isSingleValueEmpty() ? Optional.empty() : Optional.of(this.singleValue());
    }

    @Override
    public final Optional<TInMemory> getMaxValue() {
        return this.isSingleValueEmpty() ? Optional.empty() : Optional.of(this.singleValue());
    }

    @Override
    public final boolean getEmptyExists() {
        return this.isSingleValueEmpty();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.count()).append(this.singleValue()).toHashCode();
    }

    public boolean equals(Object other) {
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        if (this == other) {
            return true;
        }
        ColumnSegmentWithOneValue otherColumnSegment = (ColumnSegmentWithOneValue)other;
        return new EqualsBuilder().append(this.count(), otherColumnSegment.count()).append(this.singleValue(), otherColumnSegment.singleValue()).isEquals();
    }
}

