/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments;

import com.exponam.core.ImmutablePair;
import com.exponam.core.internalColumnSegments.ColumnSegmentBuilderHint;
import com.exponam.core.internalColumnSegments.IndexedValuesBitFieldPacker;
import com.exponam.core.internalColumnSegments.indexes.IndexCost;
import com.exponam.core.internalColumnSegments.indexes.InternalColumnSegmentIndex;
import com.exponam.core.internalColumnSegments.indexes.RunLengthEncodedIndex;
import com.exponam.core.internalColumnSegments.indexes.SortedIndexWithJumpTable;
import com.exponam.core.internalColumnSegments.indexes.SortedIndexWithoutJumpTable;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class ColumnSegmentIndexBuilder {
    private static final Map<Integer, IndexCost> thresholds = ImmutableMap.builder().put(0, new IndexCost(0)).put(1, new IndexCost(0)).put(2, new IndexCost(0)).put(3, new IndexCost(512)).put(4, new IndexCost(1024)).put(5, new IndexCost(2048)).put(6, new IndexCost(4096)).put(7, new IndexCost(8192)).put(8, new IndexCost(12288)).put(9, new IndexCost(16384)).put(10, new IndexCost(24576)).put(11, new IndexCost(32768)).put(12, new IndexCost(40960)).put(13, new IndexCost(49152)).put(14, new IndexCost(57344)).put(15, new IndexCost(65536)).build();

    ColumnSegmentIndexBuilder() {
    }

    static <TInMemory> InternalColumnSegmentIndex buildFrom(int numRows, List<TInMemory> sortedNativeValues, Map<TInMemory, List<Integer>> valuesAndRows, IndexedValuesBitFieldPacker bitFieldPacker, ColumnSegmentBuilderHint columnSegmentBuilderHint) {
        if (columnSegmentBuilderHint.hint() <= 3) {
            return null;
        }
        List unsortedRowLevelData = IntStream.range(0, numRows).map(bitFieldPacker::getValueForEntry).boxed().collect(Collectors.toList());
        List sortedRowLevelData = unsortedRowLevelData.stream().sorted().collect(Collectors.toList());
        if (sortedNativeValues.size() == unsortedRowLevelData.size() && unsortedRowLevelData.equals(sortedRowLevelData)) {
            return new InternalColumnSegmentIndex(4, null);
        }
        List<ImmutablePair<InternalColumnSegmentIndex, IndexCost>> tuples = Arrays.asList(RunLengthEncodedIndex.buildFrom(sortedNativeValues, valuesAndRows), SortedIndexWithJumpTable.buildFrom(numRows, sortedNativeValues, valuesAndRows), SortedIndexWithoutJumpTable.buildFrom(numRows, sortedNativeValues, valuesAndRows));
        ImmutablePair<InternalColumnSegmentIndex, IndexCost> columnSegmentIndexAndCost = ColumnSegmentIndexBuilder.lowestCost(tuples);
        return columnSegmentIndexAndCost.getItem2().compareTo(thresholds.get(columnSegmentBuilderHint.hint())) > 0 ? null : columnSegmentIndexAndCost.getItem1();
    }

    private static ImmutablePair<InternalColumnSegmentIndex, IndexCost> lowestCost(List<ImmutablePair<InternalColumnSegmentIndex, IndexCost>> indexersAndAssociatedCosts) {
        return (ImmutablePair)indexersAndAssociatedCosts.stream().sorted(Comparator.comparing(ImmutablePair::getItem2)).collect(Collectors.toList()).get(0);
    }
}

