/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegmentFilters;

import com.exponam.core.UnreachableCodeException;
import com.exponam.core.internalColumnSegmentFilters.ComparisonFilterDefinition;
import com.exponam.core.internalColumnSegmentFilters.FilterDefinition;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class StringFilterDefinition<TInMemory extends Comparable<? super TInMemory>, TAtRest extends Comparable<TAtRest>>
implements FilterDefinition<TInMemory, TAtRest> {
    private static final Map<Kind, ComparisonFilterDefinition.Kind> filterSimplificationMappings = ImmutableMap.builder().put(Kind.LessThan, ComparisonFilterDefinition.Kind.LessThan).put(Kind.LessThanOrEqual, ComparisonFilterDefinition.Kind.LessThanOrEqual).put(Kind.Equal, ComparisonFilterDefinition.Kind.Equal).put(Kind.NotEqual, ComparisonFilterDefinition.Kind.NotEqual).put(Kind.GreaterThanOrEqual, ComparisonFilterDefinition.Kind.GreaterThanOrEqual).put(Kind.GreaterThan, ComparisonFilterDefinition.Kind.GreaterThan).build();
    private final Kind kind;
    private final boolean caseSensitive;
    private final String operand;
    private final Function<String, Boolean> filter;

    public StringFilterDefinition(Kind kind, boolean caseSensitive, String operand) {
        this.kind = kind;
        this.caseSensitive = caseSensitive;
        this.operand = operand == null ? "" : (this.caseSensitive ? operand : operand.toUpperCase());
        switch (this.kind) {
            case LessThan: {
                this.filter = caseSensitive ? value -> operand.compareTo((String)value) < 0 : value -> operand.compareTo(value.toUpperCase()) < 0;
                break;
            }
            case LessThanOrEqual: {
                this.filter = caseSensitive ? value -> operand.compareTo((String)value) <= 0 : value -> operand.compareTo(value.toUpperCase()) <= 0;
                break;
            }
            case Equal: {
                this.filter = caseSensitive ? value -> operand.equals(value) : value -> operand.equals(value.toUpperCase());
                break;
            }
            case NotEqual: {
                this.filter = caseSensitive ? value -> !operand.equals(value) : value -> !operand.equals(value.toUpperCase());
                break;
            }
            case GreaterThanOrEqual: {
                this.filter = caseSensitive ? value -> operand.compareTo((String)value) >= 0 : value -> operand.compareTo(value.toUpperCase()) >= 0;
                break;
            }
            case GreaterThan: {
                this.filter = caseSensitive ? value -> operand.compareTo((String)value) > 0 : value -> operand.compareTo(value.toUpperCase()) > 0;
                break;
            }
            case Contains: {
                this.filter = caseSensitive ? value -> value.contains(operand) : value -> value.toUpperCase().contains(operand);
                break;
            }
            case DoesNotContain: {
                this.filter = caseSensitive ? value -> !value.contains(operand) : value -> !value.toUpperCase().contains(operand);
                break;
            }
            case StartsWith: {
                this.filter = caseSensitive ? value -> value.startsWith(operand) : value -> value.toUpperCase().startsWith(operand);
                break;
            }
            case DoesNotStartWith: {
                this.filter = caseSensitive ? value -> !value.startsWith(operand) : value -> !value.toUpperCase().startsWith(operand);
                break;
            }
            case EndsWith: {
                this.filter = caseSensitive ? value -> value.endsWith(operand) : value -> value.toUpperCase().endsWith(operand);
                break;
            }
            case DoesNotEndWith: {
                this.filter = caseSensitive ? value -> !value.endsWith(operand) : value -> !value.toUpperCase().endsWith(operand);
                break;
            }
            default: {
                throw new UnreachableCodeException();
            }
        }
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getOperand() {
        return this.operand;
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public int priority() {
        return this.caseSensitive ? 4 : 5;
    }

    @Override
    public FilterDefinition<TInMemory, TAtRest> simplify() {
        if (!this.caseSensitive) {
            return this;
        }
        return filterSimplificationMappings.containsKey((Object)this.kind) ? new ComparisonFilterDefinition(filterSimplificationMappings.get((Object)this.kind), this.operand) : this;
    }

    public boolean applyFilter(String value) {
        return this.filter.apply(value);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.kind).append(this.caseSensitive).append((Object)this.operand).build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringFilterDefinition)) {
            return false;
        }
        StringFilterDefinition other = (StringFilterDefinition)o;
        return new EqualsBuilder().append((Object)this.kind, (Object)other.getKind()).append(this.caseSensitive, other.caseSensitive).append((Object)this.operand, (Object)other.getOperand()).build();
    }

    public static enum Kind {
        LessThan,
        LessThanOrEqual,
        Equal,
        NotEqual,
        GreaterThanOrEqual,
        GreaterThan,
        Contains,
        DoesNotContain,
        StartsWith,
        DoesNotStartWith,
        EndsWith,
        DoesNotEndWith;

    }
}

