/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegmentFilters;

import com.exponam.core.internalColumnSegmentFilterResult.AllFalseBitArray;
import com.exponam.core.internalColumnSegmentFilterResult.AllTrueBitArray;
import com.exponam.core.internalColumnSegmentFilterResult.IBitArray;
import com.exponam.core.internalColumnSegmentFilterResult.Operations;
import com.exponam.core.internalColumnSegmentFilters.Filter;
import com.exponam.core.internalColumnSegmentFilters.FilterDefinition;
import com.exponam.core.internalColumnSegmentFilters.OrFilterDefinition;
import com.exponam.core.internalColumnSegments.InternalColumnSegmentBase;
import java.util.List;

public class OrFilter<TInMemory extends Comparable<? super TInMemory>, TAtRest extends Comparable<TAtRest>>
implements Filter<TInMemory, TAtRest> {
    private final InternalColumnSegmentBase<TInMemory, TAtRest> segment;

    public OrFilter(InternalColumnSegmentBase<TInMemory, TAtRest> segment) {
        this.segment = segment;
    }

    @Override
    public IBitArray apply(FilterDefinition<TInMemory, TAtRest> filterDefinition) {
        OrFilterDefinition orFilterDefinition = (OrFilterDefinition)filterDefinition;
        List operands = orFilterDefinition.getOperands();
        if (operands.isEmpty()) {
            return new AllTrueBitArray(this.segment.count());
        }
        IBitArray[] bas = new IBitArray[operands.size()];
        for (int i = 0; i < operands.size(); ++i) {
            FilterDefinition operandFilterDefinition = operands.get(i);
            bas[i] = this.segment.getFilterForDefinition(operandFilterDefinition).apply(operandFilterDefinition);
            if (bas[i].numPasses() != 0) continue;
            return new AllFalseBitArray(this.segment.count());
        }
        return Operations.or(bas);
    }
}

