/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegmentFilters;

import com.exponam.core.internalColumnSegmentFilterResult.BitArray;
import com.exponam.core.internalColumnSegmentFilterResult.IBitArray;
import com.exponam.core.internalColumnSegmentFilters.FilterDefinition;
import com.exponam.core.internalColumnSegmentFilters.StringFilter;
import com.exponam.core.internalColumnSegmentFilters.StringFilterDefinition;
import com.exponam.core.internalColumnSegments.ColumnSegmentWithSortedValues;

public class ApplyStringFilterToSortedValuesColumnSegment<TInMemory extends Comparable<? super TInMemory>, TAtRest extends Comparable<TAtRest>>
implements StringFilter<TInMemory, TAtRest> {
    private final ColumnSegmentWithSortedValues<TInMemory, TAtRest> segment;

    public ApplyStringFilterToSortedValuesColumnSegment(ColumnSegmentWithSortedValues<TInMemory, TAtRest> segment) {
        this.segment = segment;
    }

    @Override
    public IBitArray apply(FilterDefinition<TInMemory, TAtRest> filterDefinition) {
        StringFilterDefinition stringFilterDefinition = (StringFilterDefinition)filterDefinition;
        BitArray ba = new BitArray(this.segment.count());
        Comparable[] sortedValues = this.segment.sortedValues();
        for (int i = 0; i < sortedValues.length; ++i) {
            String s2;
            String string = s2 = i == 0 && this.segment.getEmptyExists() ? "" : this.segment.valueToString(sortedValues[i]);
            if (!stringFilterDefinition.applyFilter(s2)) continue;
            this.setBitArrayTrueForRows(ba, i);
        }
        return ba.toReadOnly();
    }

    private void setBitArrayTrueForRows(BitArray bitArray, int sortedValuesIndex) {
        this.segment.doForSpecificSortedItemIndex(sortedValuesIndex, row -> bitArray.set((int)row, true));
    }
}

