/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegmentFilters;

import com.exponam.core.internalColumnSegmentFilterResult.AllFalseBitArray;
import com.exponam.core.internalColumnSegmentFilterResult.AllTrueBitArray;
import com.exponam.core.internalColumnSegmentFilterResult.BitArray;
import com.exponam.core.internalColumnSegmentFilterResult.IBitArray;
import com.exponam.core.internalColumnSegmentFilters.FilterDefinition;
import com.exponam.core.internalColumnSegmentFilters.NullityFilter;
import com.exponam.core.internalColumnSegmentFilters.NullityFilterDefinition;
import com.exponam.core.internalColumnSegments.ColumnSegmentWithSortedValues;

public class ApplyNullityFilterToSortedValuesColumnSegment<TInMemory extends Comparable<? super TInMemory>, TAtRest extends Comparable<TAtRest>>
implements NullityFilter<TInMemory, TAtRest> {
    private final ColumnSegmentWithSortedValues<TInMemory, TAtRest> segment;
    private final boolean zeroethElementIsNull;

    public ApplyNullityFilterToSortedValuesColumnSegment(ColumnSegmentWithSortedValues<TInMemory, TAtRest> segment) {
        this.segment = segment;
        this.zeroethElementIsNull = segment.getEmptyExists();
    }

    @Override
    public IBitArray apply(FilterDefinition<TInMemory, TAtRest> filterDefinition) {
        NullityFilterDefinition nullityFilterDefinition = (NullityFilterDefinition)filterDefinition;
        switch (nullityFilterDefinition.getKind()) {
            case IsNull: {
                if (!this.zeroethElementIsNull) {
                    return new AllFalseBitArray(this.segment.count());
                }
                BitArray ba = new BitArray(this.segment.count());
                this.segment.doForSpecificSortedItemIndex(0, row -> ba.set((int)row, true));
                return ba.toReadOnly();
            }
            case IsNotNull: {
                if (!this.zeroethElementIsNull) {
                    return new AllTrueBitArray(this.segment.count());
                }
                BitArray ba = new BitArray(this.segment.count(), true);
                this.segment.doForSpecificSortedItemIndex(0, row -> ba.set((int)row, false));
                return ba.toReadOnly();
            }
        }
        throw new RuntimeException("Unknown filter kind");
    }
}

