/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegmentFilters;

import com.exponam.core.internalColumnSegmentFilterResult.AllFalseBitArray;
import com.exponam.core.internalColumnSegmentFilterResult.AllTrueBitArray;
import com.exponam.core.internalColumnSegmentFilterResult.IBitArray;
import com.exponam.core.internalColumnSegmentFilterResult.Operations;
import com.exponam.core.internalColumnSegmentFilters.AndFilterDefinition;
import com.exponam.core.internalColumnSegmentFilters.Filter;
import com.exponam.core.internalColumnSegmentFilters.FilterDefinition;
import com.exponam.core.internalColumnSegments.InternalColumnSegmentBase;
import java.util.List;

public class AndFilter<TInMemory extends Comparable<? super TInMemory>, TAtRest extends Comparable<TAtRest>>
implements Filter<TInMemory, TAtRest> {
    private final InternalColumnSegmentBase<TInMemory, TAtRest> segment;

    public AndFilter(InternalColumnSegmentBase<TInMemory, TAtRest> segment) {
        this.segment = segment;
    }

    @Override
    public final IBitArray apply(FilterDefinition<TInMemory, TAtRest> filterDefinition) {
        AndFilterDefinition andFilterDefinition = (AndFilterDefinition)filterDefinition;
        List operands = andFilterDefinition.getOperands();
        if (operands.isEmpty()) {
            return new AllTrueBitArray(this.segment.count());
        }
        IBitArray[] bas = new IBitArray[operands.size()];
        for (int i = 0; i < operands.size(); ++i) {
            FilterDefinition operandFilterDefinition = operands.get(i);
            bas[i] = this.segment.getFilterForDefinition(operandFilterDefinition).apply(operandFilterDefinition);
            if (bas[i].numPasses() != 0) continue;
            return new AllFalseBitArray(this.segment.count());
        }
        return Operations.and(bas);
    }
}

