/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core;

import com.exponam.core.NotYetAvailableException;
import com.exponam.core.UnreachableCodeException;
import com.exponam.core.internalColumnSegments.dates.InternalDateColumnSegmentUtilities;
import com.exponam.core.internalColumnSegments.datetimes.ExponamDateTime;
import com.exponam.core.internalColumnSegments.datetimes.InternalDateTimeColumnSegmentUtilities;
import com.exponam.core.internalColumnSegments.doubles.InternalDoubleColumnSegmentUtilities;
import com.exponam.core.internalColumnSegments.longs.InternalLongColumnSegmentUtilities;
import com.exponam.core.internalColumnSegments.times.ExponamTime;
import com.exponam.core.internalColumnSegments.times.InternalTimeColumnSegmentUtilities;
import com.exponam.core.internalColumns.ColumnTypes;
import java.sql.Timestamp;
import java.util.Date;

public class ConvertForColumnType {
    public static <TInMemory extends Comparable<? super TInMemory>> TInMemory convert(Object from, ColumnTypes columnType) {
        try {
            switch (columnType) {
                case String: {
                    if (from == null) {
                        return (TInMemory)"";
                    }
                    if (from instanceof String) {
                        return (TInMemory)((Comparable)from);
                    }
                    return (TInMemory)from.toString();
                }
                case Double: {
                    if (from == null) {
                        return (TInMemory)InternalDoubleColumnSegmentUtilities.Empty;
                    }
                    if (from instanceof Double) {
                        return (TInMemory)((Comparable)from);
                    }
                    if (from instanceof Number) {
                        return (TInMemory)Double.valueOf(((Number)from).doubleValue());
                    }
                    if (from instanceof String) {
                        return (TInMemory)Double.valueOf(Double.parseDouble((String)from));
                    }
                    throw new ConversionException(from, columnType);
                }
                case Long: {
                    if (from == null) {
                        return (TInMemory)InternalLongColumnSegmentUtilities.Empty;
                    }
                    if (from instanceof Long) {
                        return (TInMemory)((Comparable)from);
                    }
                    if (from instanceof Number) {
                        return (TInMemory)ConvertForColumnType.getAsLongWithPrecisionCheck((Number)from, columnType);
                    }
                    if (from instanceof String) {
                        return (TInMemory)Long.valueOf(Long.parseLong((String)from));
                    }
                    throw new ConversionException(from, columnType);
                }
                case Date: {
                    if (from == null) {
                        return (TInMemory)InternalDateColumnSegmentUtilities.EmptyDate;
                    }
                    if (from instanceof java.sql.Date) {
                        return (TInMemory)((Comparable)from);
                    }
                    if (from instanceof Date) {
                        return (TInMemory)new java.sql.Date(((Date)from).getTime());
                    }
                    if (from instanceof String) {
                        return ConvertForColumnType.convert(java.sql.Date.valueOf((String)from), columnType);
                    }
                    throw new ConversionException(from, columnType);
                }
                case DateTime: {
                    if (from == null) {
                        return (TInMemory)InternalDateTimeColumnSegmentUtilities.EmptyDateTime;
                    }
                    if (from instanceof ExponamDateTime) {
                        return (TInMemory)((Comparable)from);
                    }
                    if (from instanceof Number) {
                        return (TInMemory)ExponamDateTime.fromMillisInvariantWithTimezone(ConvertForColumnType.getAsLongWithPrecisionCheck((Number)from, columnType));
                    }
                    if (from instanceof Date) {
                        return (TInMemory)ExponamDateTime.fromMillisInvariantWithTimezone(((Date)from).getTime());
                    }
                    if (from instanceof String) {
                        return ConvertForColumnType.convert(Timestamp.valueOf((String)from), columnType);
                    }
                    throw new ConversionException(from, columnType);
                }
                case Boolean: {
                    throw new NotYetAvailableException("boolean columns");
                }
                case Time: {
                    if (from == null) {
                        return (TInMemory)InternalTimeColumnSegmentUtilities.EMPTY_TIME;
                    }
                    if (from instanceof ExponamTime) {
                        return (TInMemory)((Comparable)from);
                    }
                    if (from instanceof Date) {
                        ExponamTime.fromDate((Date)from);
                    }
                    if (from instanceof Number) {
                        return (TInMemory)new ExponamTime(ConvertForColumnType.getAsLongWithPrecisionCheck((Number)from, columnType).intValue());
                    }
                    throw new ConversionException(from, columnType);
                }
            }
        }
        catch (Exception ex) {
            throw new ConversionException(from, columnType, ex);
        }
        throw new UnreachableCodeException();
    }

    private static Long getAsLongWithPrecisionCheck(Number n, ColumnTypes columnType) {
        Double l;
        Double d = n.doubleValue();
        if (d.compareTo(l = Double.valueOf((double)n.longValue() * 1.0)) != 0) {
            throw new ConversionException(String.format("Converting from %s to a %s column type would lose precision", n.toString(), columnType.name()));
        }
        return n.longValue();
    }

    public static class ConversionException
    extends RuntimeException {
        ConversionException(String message) {
            super(message);
        }

        ConversionException(Object from, ColumnTypes columnType) {
            super(String.format("Cannot convert from '%s' to a type appropriate for a %s column", from, columnType.name()));
        }

        ConversionException(Object from, ColumnTypes columnType, Throwable t) {
            super(String.format("Cannot convert from '%s' to a type appropriate for a %s column", from, columnType.name()), t);
        }
    }
}

