/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core;

import java.io.Serializable;
import java.util.Objects;

public class ImmutablePair<K, V>
implements Serializable {
    private final K item1;
    private final V item2;

    ImmutablePair(K key, V value) {
        this.item1 = key;
        this.item2 = value;
    }

    public static <K, V> ImmutablePair<K, V> of(K item1, V item2) {
        return new ImmutablePair<K, V>(item1, item2);
    }

    public K getItem1() {
        return this.item1;
    }

    public V getItem2() {
        return this.item2;
    }

    public String toString() {
        return this.item1 + "=" + this.item2;
    }

    public int hashCode() {
        return this.item1.hashCode() * 13 + (this.item2 == null ? 0 : this.item2.hashCode());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ImmutablePair) {
            ImmutablePair pair = (ImmutablePair)o;
            if (!Objects.equals(this.item1, pair.item1)) {
                return false;
            }
            return Objects.equals(this.item2, pair.item2);
        }
        return false;
    }
}

