/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.reader;

import com.exponam.core.InternalMetadatum;
import com.exponam.core.reader.BigReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class MetadataReader {
    private final BigReader bigReader;

    public MetadataReader(BigReader bigReader) {
        this.bigReader = Objects.requireNonNull(bigReader, "bigrReader");
    }

    public List<Pair<Security, InternalMetadatum>> getMetadata(Predicate<Pair<String, InternalMetadatum>> selectPredicate, boolean fetchPublicOnly) throws IOException {
        ArrayList<Pair<Security, InternalMetadatum>> result = new ArrayList<Pair<Security, InternalMetadatum>>();
        BiConsumer<Map, Security> processMetadata = (metadata, security) -> {
            for (Map.Entry entry : metadata.entrySet()) {
                for (InternalMetadatum metadatum : (List)entry.getValue()) {
                    if (!selectPredicate.test(Pair.of((Object)((String)entry.getKey()), (Object)metadatum))) continue;
                    result.add(Pair.of((Object)security, (Object)metadatum));
                }
            }
        };
        processMetadata.accept(this.bigReader.getTrailer().getPublicMetadata(), Security.Public);
        if (!fetchPublicOnly) {
            processMetadata.accept(this.bigReader.getTrailer().getPrivateTrailerReadable(this.bigReader.getDecryptor()).getPrivateMetadata(), Security.Private);
        }
        return result;
    }

    public List<Pair<Security, InternalMetadatum>> getMetadata(String key, boolean fetchPublicOnly) throws IOException {
        Map<String, List<InternalMetadatum>> publicMetadata = this.bigReader.getTrailer().getPublicMetadata();
        Map<String, List<InternalMetadatum>> privateMetadata = fetchPublicOnly ? null : this.bigReader.getTrailer().getPrivateTrailerReadable(this.bigReader.getDecryptor()).getPrivateMetadata();
        ArrayList<Pair<Security, InternalMetadatum>> result = new ArrayList<Pair<Security, InternalMetadatum>>();
        if (publicMetadata.containsKey(key)) {
            result.addAll(publicMetadata.get(key).stream().map(internalMetadatum -> Pair.of((Object)((Object)Security.Public), (Object)internalMetadatum)).collect(Collectors.toList()));
        }
        if (privateMetadata != null && privateMetadata.containsKey(key)) {
            result.addAll(privateMetadata.get(key).stream().map(internalMetadatum -> Pair.of((Object)((Object)Security.Private), (Object)internalMetadatum)).collect(Collectors.toList()));
        }
        return result;
    }

    public Pair<Security, InternalMetadatum> getSingleMetadatum(String key, boolean publicOnly, boolean failIfEmpty) throws IOException {
        List<Pair<Security, InternalMetadatum>> metadata = this.getMetadata(key, publicOnly);
        if (metadata.size() > 1) {
            throw new IllegalArgumentException(String.format("Found %d entries for %s, expected only 1", metadata.size(), key));
        }
        if (failIfEmpty && metadata.isEmpty()) {
            throw new IllegalArgumentException(String.format("No entry found for %s", key));
        }
        return metadata.isEmpty() ? null : metadata.get(0);
    }

    public static enum Security {
        Private,
        Public;

    }
}

