/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments.longs;

import com.exponam.core.internalColumnSegments.ColumnSegmentWithRowOrderValues;
import com.exponam.core.internalColumnSegments.longs.InternalLongColumnSegmentUtilities;
import com.exponam.core.protobuf.columnsegments.ColumnSegmentBase;
import com.exponam.core.protobuf.columnsegments.LongWithRowOrderDataColumnSegment;
import com.google.common.collect.Iterators;
import java.util.List;
import java.util.Map;

public class InternalLongWithRowOrderDataColumnSegment
extends ColumnSegmentWithRowOrderValues<Long, Long> {
    private final int numValues;
    private Long minValue;
    private Long maxValue;
    private boolean emptyExists;
    private Long[] rowOrderValues;

    InternalLongWithRowOrderDataColumnSegment(int numRowsInSegment, Map<Long, List<Integer>> valuesAndRows) {
        super(l -> l, (TAtRest l) -> l);
        this.numValues = numRowsInSegment;
        this.ingest(numRowsInSegment, valuesAndRows, rowOrderValues -> {
            this.rowOrderValues = rowOrderValues;
        }, min2 -> {
            this.minValue = min2;
        }, max -> {
            this.maxValue = max;
        }, empty -> {
            this.emptyExists = empty;
        }, Long.class);
    }

    InternalLongWithRowOrderDataColumnSegment(LongWithRowOrderDataColumnSegment protoSegment) {
        super(s2 -> s2, (TAtRest s2) -> s2);
        this.numValues = protoSegment.getNumValues();
        this.minValue = protoSegment.getMinValue();
        this.maxValue = protoSegment.getMaxValue();
        this.emptyExists = protoSegment.getEmptyExists();
        this.rowOrderValues = protoSegment.getRowOrderValuesList().toArray(new Long[0]);
    }

    protected Long[] rowOrderValues() {
        return this.rowOrderValues;
    }

    @Override
    protected boolean isValueEmpty(Long value) {
        return value.equals(InternalLongColumnSegmentUtilities.Empty);
    }

    @Override
    protected String valueToString(Long value) {
        return InternalLongColumnSegmentUtilities.atRestToString.apply(value, this.getColumn());
    }

    @Override
    public int count() {
        return this.numValues;
    }

    @Override
    public ColumnSegmentBase toProto() {
        LongWithRowOrderDataColumnSegment protoSegment = LongWithRowOrderDataColumnSegment.newBuilder().setNumValues(this.numValues).setMinValue(this.minValue).setMaxValue(this.maxValue).setEmptyExists(this.emptyExists).addAllRowOrderValues(() -> Iterators.forArray(this.rowOrderValues)).build();
        return ColumnSegmentBase.newBuilder().mergeLongWithRowOrderDataColumnSegment(protoSegment).build();
    }
}

