/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments.datetimes;

import java.sql.Timestamp;
import java.time.Duration;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

class DateNormalizer {
    private static final long TICKS_PER_MILLISECOND = 10000L;
    private static final Calendar DOT_NET_DATE_TIME_START = DateNormalizer.cSharpDateTimeMinValue();
    static final Timestamp EMPTY_DATE_TIME = new Timestamp(DOT_NET_DATE_TIME_START.getTimeInMillis());
    private static final Calendar JAVA_DATE_TIME_START = new GregorianCalendar(1970, 0, 1, 0, 0);
    private static final Duration PLATFORM_DATE_DIFFERENCE = Duration.between(DOT_NET_DATE_TIME_START.getTime().toInstant(), JAVA_DATE_TIME_START.getTime().toInstant());
    private static final long EXTRA_DIFFERENCE_IN_MILLIS = 259200000L;
    private static final long PLATFORM_DIFFERENCE_IN_MILLIS = PLATFORM_DATE_DIFFERENCE.toMillis() - 259200000L;

    DateNormalizer() {
    }

    static Timestamp javaTimestampFromCSharpTicks(long cSharpTicks) {
        long cSharpDateInMillis = cSharpTicks / 10000L;
        Timestamp date = new Timestamp(cSharpDateInMillis - PLATFORM_DIFFERENCE_IN_MILLIS);
        return date;
    }

    static long cSharpTicksFromJavaTimestamp(Timestamp javaDate) {
        long javaDateInMillis = javaDate.getTime();
        long cSharpDateInMillis = javaDateInMillis + PLATFORM_DIFFERENCE_IN_MILLIS;
        long cSharpDateInTicks = cSharpDateInMillis * 10000L;
        return cSharpDateInTicks;
    }

    private static Calendar cSharpDateTimeMinValue() {
        GregorianCalendar c = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        c.set(1, 0, 1, 0, 0, 0);
        return c;
    }
}

