/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments.dates;

import com.exponam.core.internalColumnSegments.ColumnSegmentWithRowOrderValues;
import com.exponam.core.internalColumnSegments.dates.InternalDateColumnSegmentUtilities;
import com.exponam.core.protobuf.columnsegments.ColumnSegmentBase;
import com.exponam.core.protobuf.columnsegments.DateWithRowOrderDataColumnSegment;
import com.google.common.collect.Iterators;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class InternalDateWithRowOrderDataColumnSegment
extends ColumnSegmentWithRowOrderValues<Date, Integer> {
    private final int numValues;
    private Integer minValue;
    private Integer maxValue;
    private boolean emptyExists;
    private Integer[] rowOrderValues;

    InternalDateWithRowOrderDataColumnSegment(int numRowsInSegment, Map<Date, List<Integer>> valuesAndRows) {
        super(InternalDateColumnSegmentUtilities.toAtRest, InternalDateColumnSegmentUtilities.toInMemory);
        this.numValues = numRowsInSegment;
        this.ingest(numRowsInSegment, valuesAndRows, rowOrderValues -> {
            this.rowOrderValues = rowOrderValues;
        }, min2 -> {
            this.minValue = min2;
        }, max -> {
            this.maxValue = max;
        }, empty -> {
            this.emptyExists = empty;
        }, Integer.class);
    }

    InternalDateWithRowOrderDataColumnSegment(DateWithRowOrderDataColumnSegment protoSegment) {
        super(InternalDateColumnSegmentUtilities.toAtRest, InternalDateColumnSegmentUtilities.toInMemory);
        this.numValues = protoSegment.getNumValues();
        this.minValue = protoSegment.getMinDayValue();
        this.maxValue = protoSegment.getMaxDayValue();
        this.emptyExists = protoSegment.getEmptyExists();
        this.rowOrderValues = protoSegment.getRowOrderDayValuesList().toArray(new Integer[0]);
    }

    protected Integer[] rowOrderValues() {
        return this.rowOrderValues;
    }

    @Override
    protected boolean isValueEmpty(Integer value) {
        return value.equals(InternalDateColumnSegmentUtilities.Empty);
    }

    @Override
    protected String valueToString(Integer value) {
        return InternalDateColumnSegmentUtilities.atRestToString.apply(value, this.getColumn());
    }

    @Override
    public int count() {
        return this.numValues;
    }

    @Override
    public ColumnSegmentBase toProto() {
        DateWithRowOrderDataColumnSegment protoSegment = DateWithRowOrderDataColumnSegment.newBuilder().setNumValues(this.numValues).setMinDayValue(this.minValue).setMaxDayValue(this.maxValue).setEmptyExists(this.emptyExists).addAllRowOrderDayValues(() -> Iterators.forArray(this.rowOrderValues)).build();
        return ColumnSegmentBase.newBuilder().mergeDateWithRowOrderDataColumnSegment(protoSegment).build();
    }
}

