/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments;

import com.exponam.core.internalColumnSegmentFilterResult.BitArray;
import com.exponam.core.internalColumnSegmentFilterResult.IBitArray;
import com.exponam.core.internalColumnSegmentFilters.InternalColumnSegmentFilterBase;
import com.exponam.core.internalColumnSegments.ColumnSegmentBuilderHint;
import com.exponam.core.internalColumnSegments.ColumnSegmentIndexBuilder;
import com.exponam.core.internalColumnSegments.IndexedValuesBitFieldPacker;
import com.exponam.core.internalColumnSegments.InternalColumnSegmentBase;
import com.exponam.core.internalColumnSegments.indexes.InternalColumnSegmentIndex;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;

public abstract class ColumnSegmentWithSortedValues<TInMemory, TAtRest>
extends InternalColumnSegmentBase {
    private final Function<TInMemory, TAtRest> convertToAtRest;
    private final Function<TAtRest, TInMemory> convertToInMemory;
    private IndexedValuesBitFieldPacker bitFieldPacker;

    protected ColumnSegmentWithSortedValues(Function<TInMemory, TAtRest> convertToAtRest, Function<TAtRest, TInMemory> convertToInMemory) {
        this.convertToAtRest = convertToAtRest;
        this.convertToInMemory = convertToInMemory;
    }

    protected void ingest(int numRowsInSegment, Map<TInMemory, List<Integer>> valuesAndRows, Consumer<List<TAtRest>> sortedValuesSetterConsumer, Consumer<long[]> packedIndexSetterConsumer, ColumnSegmentBuilderHint columnSegmentBuilderHint, Consumer<InternalColumnSegmentIndex> columnSegmentIndexConsumer) {
        List sortedNativeValues = valuesAndRows.keySet().stream().sorted().collect(Collectors.toList());
        List sortedAtRestValues = sortedNativeValues.stream().map(this.convertToAtRest::apply).collect(Collectors.toList());
        long[] packedIndex = IndexedValuesBitFieldPacker.packedEntries(sortedAtRestValues.size() - 1, numRowsInSegment);
        IndexedValuesBitFieldPacker bitFieldPacker = new IndexedValuesBitFieldPacker(packedIndex, sortedAtRestValues.size() - 1);
        int rowsWithEntryValues = 0;
        for (int indexInSortedValues = 0; indexInSortedValues < sortedAtRestValues.size(); ++indexInSortedValues) {
            List<Integer> rowsForSortedValue = valuesAndRows.get(sortedNativeValues.get(indexInSortedValues));
            for (Integer row : rowsForSortedValue) {
                bitFieldPacker.putValueForEntry(row, indexInSortedValues);
                ++rowsWithEntryValues;
            }
        }
        if (rowsWithEntryValues != numRowsInSegment) {
            throw new IllegalArgumentException("wrong number of rows ingested");
        }
        InternalColumnSegmentIndex internalColumnSegmentIndex = ColumnSegmentIndexBuilder.buildFrom(numRowsInSegment, sortedNativeValues, valuesAndRows, bitFieldPacker, columnSegmentBuilderHint);
        sortedValuesSetterConsumer.accept(sortedAtRestValues);
        packedIndexSetterConsumer.accept(packedIndex);
        columnSegmentIndexConsumer.accept(internalColumnSegmentIndex);
    }

    protected abstract TAtRest[] sortedValues();

    protected abstract long[] packedIndex();

    protected abstract InternalColumnSegmentIndex index();

    protected abstract boolean isValueEmpty(TAtRest var1);

    protected abstract String valueToString(TAtRest var1);

    protected TAtRest get(int index) {
        int indexInSortedValues = this.getBitFieldPacker().getValueForEntry(index);
        if (indexInSortedValues < 0 || indexInSortedValues > this.sortedValues().length - 1) {
            throw new IllegalArgumentException("indexInSortedValues out of range");
        }
        return this.sortedValues()[indexInSortedValues];
    }

    private IndexedValuesBitFieldPacker getBitFieldPacker() {
        if (this.bitFieldPacker != null) {
            return this.bitFieldPacker;
        }
        this.bitFieldPacker = new IndexedValuesBitFieldPacker(this.packedIndex(), this.sortedValues().length - 1);
        return this.bitFieldPacker;
    }

    @Override
    public <T> T atRestValueForIndex(int index) {
        return (T)this.get(index);
    }

    @Override
    public <T> T inMemoryValueForIndex(int index) {
        return (T)this.convertToInMemory.apply(this.get(index));
    }

    @Override
    public String stringValueForIndex(int index) {
        return this.valueToString(this.get(index));
    }

    @Override
    public IBitArray applyFilter(InternalColumnSegmentFilterBase filter) {
        BitArray rowLevelResults = new BitArray(this.count());
        InternalColumnSegmentIndex internalColumnSegmentIndex = this.index();
        if (internalColumnSegmentIndex != null) {
            for (int i = 0; i < this.sortedValues().length; ++i) {
                if (!filter.passesFilter(this.sortedValues()[i])) continue;
                internalColumnSegmentIndex.forRowsForElementDo(i, this.sortedValues().length, this.getBitFieldPacker(), row -> rowLevelResults.set((int)row, true));
            }
            return rowLevelResults.toReadOnly();
        }
        if (this.sortedValues().length <= 64) {
            int i;
            long bitFieldForMatchingSortedValues = 0L;
            for (i = 0; i < this.sortedValues().length; ++i) {
                if (!filter.passesFilter(this.sortedValues()[i])) continue;
                bitFieldForMatchingSortedValues |= 1L << i;
            }
            for (i = 0; i < this.count(); ++i) {
                int indexInSortedValues = this.getBitFieldPacker().getValueForEntry(i);
                long bitFieldForSpecificSortedValueValue = 1L << indexInSortedValues;
                if ((bitFieldForMatchingSortedValues & bitFieldForSpecificSortedValueValue) == 0L) continue;
                rowLevelResults.set(i, true);
            }
            return rowLevelResults.toReadOnly();
        }
        for (int i = 0; i < this.count(); ++i) {
            if (!filter.passesFilter(this.get(i))) continue;
            rowLevelResults.set(i, true);
        }
        return rowLevelResults.toReadOnly();
    }

    protected static long[] toArray(List<Long> longList) {
        long[] result = new long[longList.size()];
        for (int i = 0; i < longList.size(); ++i) {
            result[i] = longList.get(i);
        }
        return result;
    }

    protected static long[] toArray(Long[] longList) {
        long[] result = new long[longList.length];
        for (int i = 0; i < longList.length; ++i) {
            result[i] = longList[i];
        }
        return result;
    }

    public int hashCode() {
        return this.sortedValues().hashCode();
    }

    public boolean equals(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        if (other == this) {
            return true;
        }
        ColumnSegmentWithSortedValues otherColumnSegment = (ColumnSegmentWithSortedValues)other;
        return new EqualsBuilder().append(this.packedIndex(), otherColumnSegment.packedIndex()).append((Object[])this.sortedValues(), (Object[])otherColumnSegment.sortedValues()).isEquals();
    }
}

