/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core;

import com.exponam.core.InternalMetadatum;
import com.exponam.core.InternalWorksheet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class InternalPrivateTrailer<TWorksheet extends InternalWorksheet> {
    private final List<TWorksheet> worksheets;
    private final Map<String, List<InternalMetadatum>> privateMetadata;
    private final Map<String, Integer> extrasLookup;

    public InternalPrivateTrailer(List<TWorksheet> worksheets, Map<String, List<InternalMetadatum>> privateMetadata, Map<String, Integer> extrasLookup) {
        this.worksheets = Objects.requireNonNull(worksheets, "worksheets");
        this.privateMetadata = Objects.requireNonNull(privateMetadata, "privateMetadata");
        this.extrasLookup = Objects.requireNonNull(extrasLookup, "extrasLookup");
    }

    public int numWorksheets() {
        return this.worksheets.size();
    }

    public TWorksheet getWorksheet(int worksheetIndex) {
        return (TWorksheet)((InternalWorksheet)this.worksheets.get(worksheetIndex));
    }

    protected List<TWorksheet> getWorksheets() {
        return this.worksheets;
    }

    public Map<String, List<InternalMetadatum>> getPrivateMetadata() {
        return this.privateMetadata;
    }

    public Map<String, Integer> getExtrasLookup() {
        return this.extrasLookup;
    }
}

