/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.reader;

import com.exponam.core.internalColumnSegments.dates.InternalDateColumnSegmentUtilities;
import com.exponam.core.internalColumnSegments.datetimes.InternalDateTimeColumnSegmentUtilities;
import com.exponam.core.internalColumnSegments.doubles.InternalDoubleColumnSegmentUtilities;
import com.exponam.core.internalColumnSegments.longs.InternalLongColumnSegmentUtilities;
import com.exponam.core.internalColumnSegments.times.InternalTimeColumnSegmentUtilities;
import com.exponam.core.internalColumns.ColumnTypes;
import com.exponam.core.reader.BigReader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.Objects;
import java.util.Optional;

public final class Marshaller {
    private final BigReader bigReader;

    public Marshaller(BigReader bigReader) {
        this.bigReader = Objects.requireNonNull(bigReader, "bigReader");
    }

    public <T> T getColumnValueAs(int worksheetIndex, int rowIndex, int columnIndex, Type desiredType) {
        if (String.class.equals((Object)desiredType)) {
            return (T)this.bigReader.getValueAsString(worksheetIndex, rowIndex, columnIndex);
        }
        ColumnTypes columnType = this.bigReader.getWorksheet(worksheetIndex).getColumns().get(columnIndex).getType();
        if (desiredType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)desiredType;
            Type rawType = ((ParameterizedType)desiredType).getRawType();
            if (!rawType.equals(Optional.class)) {
                throw new IllegalArgumentException(String.format("Only Optional<T> permitted as a parameterized type, instead found '%s'", desiredType));
            }
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            int len = typeArguments.length;
            if (len == 0) {
                throw new IllegalArgumentException(String.format("Unable to convert to an unqualified type '%s'", desiredType));
            }
            if (len > 1) {
                throw new IllegalArgumentException(String.format("Unable to convert to type '%s'", desiredType));
            }
            Type targetType = typeArguments[0];
            return (T)Optional.ofNullable(this.getForTargetType(worksheetIndex, rowIndex, columnIndex, targetType, columnType));
        }
        if (desiredType.equals(Optional.class)) {
            throw new IllegalArgumentException(String.format("Expected a qualified Optional<T> instead of '%s'", desiredType));
        }
        return this.getForTargetType(worksheetIndex, rowIndex, columnIndex, desiredType, columnType);
    }

    private <T> T getForTargetType(int worksheetIndex, int rowIndex, int columnIndex, Type desiredType, ColumnTypes columnType) {
        if (desiredType.equals(String.class)) {
            return (T)this.bigReader.getValueAsString(worksheetIndex, rowIndex, columnIndex);
        }
        Object o = this.bigReader.getValue(worksheetIndex, rowIndex, columnIndex);
        if (o == null) {
            return null;
        }
        switch (columnType) {
            case Double: {
                if (!InternalDoubleColumnSegmentUtilities.Empty.equals(o)) break;
                return null;
            }
            case Long: {
                if (!InternalLongColumnSegmentUtilities.Empty.equals(o)) break;
                return null;
            }
            case Date: {
                if (!InternalDateColumnSegmentUtilities.EmptyDate.equals(o)) break;
                return null;
            }
            case DateTime: {
                if (!InternalDateTimeColumnSegmentUtilities.EmptyDateTime.equals(o)) break;
                return null;
            }
            case Boolean: {
                break;
            }
            case Time: {
                if (!InternalTimeColumnSegmentUtilities.EMPTY_TIME.equals(o)) break;
                return null;
            }
        }
        if (o.getClass().equals(desiredType)) {
            return (T)o;
        }
        if (o instanceof Optional) {
            Optional optionalO = (Optional)o;
            if (optionalO.isPresent()) {
                o = optionalO.get();
            } else {
                return null;
            }
        }
        if (o instanceof Double) {
            Double doubleO = (Double)o;
            if (desiredType.equals(Long.class)) {
                return (T)Long.valueOf(doubleO.longValue());
            }
            if (desiredType.equals(Integer.class)) {
                return (T)Integer.valueOf(doubleO.intValue());
            }
            if (desiredType.equals(Short.class)) {
                return (T)Short.valueOf(doubleO.shortValue());
            }
            if (desiredType.equals(Byte.class)) {
                return (T)Byte.valueOf(doubleO.byteValue());
            }
            if (desiredType.equals(Float.class)) {
                return (T)Float.valueOf(doubleO.floatValue());
            }
            if (desiredType.equals(BigDecimal.class)) {
                return (T)BigDecimal.valueOf(doubleO);
            }
        }
        if (o instanceof Long) {
            Long longO = (Long)o;
            if (desiredType.equals(Integer.class)) {
                return (T)Integer.valueOf(longO.intValue());
            }
            if (desiredType.equals(Short.class)) {
                return (T)Short.valueOf(longO.shortValue());
            }
            if (desiredType.equals(Byte.class)) {
                return (T)Byte.valueOf(longO.byteValue());
            }
            if (desiredType.equals(Double.class)) {
                return (T)Double.valueOf(longO.doubleValue());
            }
            if (desiredType.equals(Float.class)) {
                return (T)Float.valueOf(longO.floatValue());
            }
            if (desiredType.equals(BigDecimal.class)) {
                return (T)BigDecimal.valueOf(longO);
            }
        }
        if (o instanceof Boolean) {
            int booleanIntValue;
            boolean booleanO = (Boolean)o;
            int n = booleanIntValue = booleanO ? 1 : 0;
            if (desiredType.equals(Long.class)) {
                return (T)Long.valueOf(booleanIntValue);
            }
            if (desiredType.equals(Integer.class)) {
                return (T)Integer.valueOf(booleanIntValue);
            }
            if (desiredType.equals(Short.class)) {
                return (T)Short.valueOf((short)booleanIntValue);
            }
            if (desiredType.equals(Byte.class)) {
                return (T)Byte.valueOf((byte)booleanIntValue);
            }
            if (desiredType.equals(Double.class)) {
                return (T)Double.valueOf(booleanIntValue);
            }
            if (desiredType.equals(Float.class)) {
                return (T)Float.valueOf(booleanIntValue);
            }
            if (desiredType.equals(BigDecimal.class)) {
                return (T)BigDecimal.valueOf(booleanIntValue);
            }
        }
        if (o instanceof java.util.Date) {
            switch (columnType) {
                case Date: 
                case DateTime: 
                case Time: {
                    java.util.Date dateO = (java.util.Date)o;
                    if (desiredType.equals(Date.class)) {
                        return (T)new Date(dateO.getTime());
                    }
                    if (desiredType.equals(java.util.Date.class)) {
                        return (T)new java.util.Date(dateO.getTime());
                    }
                    if (desiredType.equals(Long.class)) {
                        return (T)Long.valueOf(dateO.getTime());
                    }
                    if (!desiredType.equals(BigDecimal.class)) break;
                    return (T)BigDecimal.valueOf(dateO.getTime());
                }
            }
        }
        throw new IllegalArgumentException(String.format("Unable to convert object of type '%s' to desired type '%s' for worksheet '%d', row '%d', and column '%d',", o.getClass().getName(), desiredType, worksheetIndex, rowIndex, columnIndex));
    }
}

