/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments.indexes;

import com.exponam.core.ImmutablePair;
import com.exponam.core.internalColumnSegments.indexes.IndexCost;
import com.exponam.core.internalColumnSegments.indexes.InternalColumnSegmentIndex;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class RunLengthEncodedIndex {
    public static <TInMemory> ImmutablePair<InternalColumnSegmentIndex, IndexCost> buildFrom(List<TInMemory> sortedNativeValues, Map<TInMemory, List<Integer>> valuesAndRows) {
        ArrayList<Integer> jumpTable = new ArrayList<Integer>(sortedNativeValues.size());
        ArrayList<Integer> runLengthEncodings = new ArrayList<Integer>();
        int runLengthEncodingsBase = sortedNativeValues.size();
        for (TInMemory sortedNativeValue : sortedNativeValues) {
            jumpTable.add(runLengthEncodingsBase + runLengthEncodings.size());
            List<Integer> rowsForValue = valuesAndRows.get(sortedNativeValue);
            RunLengthEncodedIndex.encode(rowsForValue, runLengthEncodings);
        }
        jumpTable.addAll(runLengthEncodings);
        short[] combined = InternalColumnSegmentIndex.toArray(jumpTable);
        return ImmutablePair.of(new InternalColumnSegmentIndex(1, combined), new IndexCost(combined.length));
    }

    private static void encode(List<Integer> rows, List<Integer> runLengthEncodings) {
        int i = 0;
        while (i < rows.size()) {
            int row = rows.get(i++);
            int numAdditionalValuesInRun = 0;
            if (i < rows.size() - 1 && rows.get(i) == row + 1 && rows.get(i + 1) == row + 2) {
                while (i < rows.size() && rows.get(i) == row + 1 + numAdditionalValuesInRun) {
                    ++i;
                    ++numAdditionalValuesInRun;
                }
            }
            if (numAdditionalValuesInRun == 0) {
                runLengthEncodings.add(row);
                continue;
            }
            runLengthEncodings.add(~row);
            runLengthEncodings.add(numAdditionalValuesInRun);
        }
    }

    static void forRowsForElementsDo(int jumpTableIndex, int jumpTableSize, short[] combinedJumpTableAndRunLengthEncodings, Consumer<Integer> doForRow) {
        int offsetToRunLengthEncoding = combinedJumpTableAndRunLengthEncodings[jumpTableIndex];
        int stopAt = jumpTableIndex == jumpTableSize - 1 ? combinedJumpTableAndRunLengthEncodings.length : combinedJumpTableAndRunLengthEncodings[jumpTableIndex + 1];
        for (int i = offsetToRunLengthEncoding; i < stopAt; ++i) {
            int row = combinedJumpTableAndRunLengthEncodings[i];
            int numAdditionalValuesInRun = 0;
            if (row < 0) {
                row ^= 0xFFFFFFFF;
                numAdditionalValuesInRun = combinedJumpTableAndRunLengthEncodings[++i];
            }
            for (int j = 0; j < numAdditionalValuesInRun + 1; ++j) {
                doForRow.accept(row + j);
            }
        }
    }
}

