/*
 * Decompiled with CFR 0.152.
 */
package com.exponam.core.internalColumnSegments.bool;

import com.exponam.core.internalColumnSegmentFilterResult.BitArray;
import com.exponam.core.internalColumnSegmentFilterResult.IBitArray;
import com.exponam.core.internalColumnSegmentFilters.InternalColumnSegmentFilterBase;
import com.exponam.core.internalColumnSegments.InternalColumnSegmentBase;
import com.exponam.core.internalColumnSegments.bool.InternalBooleanAllEmptyColumnSegment;
import com.exponam.core.internalColumnSegments.bool.InternalBooleanAllFalseColumnSegment;
import com.exponam.core.internalColumnSegments.bool.InternalBooleanAllTrueColumnSegment;
import com.exponam.core.internalColumnSegments.bool.InternalBooleanAllValuesColumnSegment;
import com.exponam.core.internalColumnSegments.bool.InternalBooleanTrueOrFalseValuesColumnSegment;
import java.util.List;
import java.util.Optional;

public abstract class InternalBooleanColumnSegmentBase
extends InternalColumnSegmentBase {
    public static final Optional<Boolean> EMPTY = Optional.empty();

    public static final InternalBooleanColumnSegmentBase getAppropriateColumnSegment(List<Optional<Boolean>> values, int numTrue, int numFalse, int numNull) {
        if (numTrue == values.size()) {
            return new InternalBooleanAllTrueColumnSegment(numTrue);
        }
        if (numFalse == values.size()) {
            return new InternalBooleanAllFalseColumnSegment(numFalse);
        }
        if (numNull == values.size()) {
            return new InternalBooleanAllEmptyColumnSegment(numNull);
        }
        if (numNull == 0) {
            return new InternalBooleanTrueOrFalseValuesColumnSegment(values);
        }
        return new InternalBooleanAllValuesColumnSegment(values);
    }

    protected abstract Optional<Boolean> get(int var1);

    @Override
    public <T> T atRestValueForIndex(int index) {
        return (T)this.get(index);
    }

    @Override
    public <T> T inMemoryValueForIndex(int index) {
        return (T)this.get(index);
    }

    @Override
    public String stringValueForIndex(int index) {
        Optional<Boolean> b = this.get(index);
        return b.isPresent() ? b.get().toString() : "";
    }

    @Override
    public IBitArray applyFilter(InternalColumnSegmentFilterBase filter) {
        BitArray rowLevelResults = new BitArray(this.count());
        for (int i = 0; i < this.count(); ++i) {
            if (!filter.passesFilter(this.get(i))) continue;
            rowLevelResults.set(i, true);
        }
        return rowLevelResults.toReadOnly();
    }
}

