/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.util;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.commons.logging.LogFactory;
import org.enhydra.jdbc.util.Logger;
import org.enhydra.jdbc.util.RequestCacheObject;

public class RequestCache {
    private static Hashtable cache_ = null;
    private static Hashtable dsCache_ = null;
    private static Hashtable requests_ = null;
    private static RequestCache theCache_ = null;
    private long timeToLive_ = 86400000L;
    private String path = null;
    private static Logger logger;

    public static synchronized RequestCache getInstance() {
        if (theCache_ == null) {
            theCache_ = new RequestCache();
        }
        return theCache_;
    }

    public static synchronized RequestCache getInstance(String path) {
        if (theCache_ == null) {
            theCache_ = new RequestCache(path);
        }
        return theCache_;
    }

    public RequestCache() {
        if (logger == null) {
            logger = new Logger(LogFactory.getLog((String)"org.enhydra.jdbc.util"));
        }
        if (cache_ == null) {
            cache_ = new Hashtable();
        }
        if (requests_ == null) {
            requests_ = new Hashtable();
        }
        if (dsCache_ == null) {
            dsCache_ = new Hashtable();
        }
        this.readConfigurationFile();
    }

    public RequestCache(String path) {
        if (cache_ == null) {
            cache_ = new Hashtable();
        }
        if (requests_ == null) {
            requests_ = new Hashtable();
        }
        this.path = path;
        this.readConfigurationFile();
    }

    public void readConfigurationFile() {
        if (this.path != null) {
            try {
                logger.debug("RequestCache: readConfigurationFile try to open file=" + this.path);
                FileInputStream fstream = new FileInputStream(this.path);
                DataInputStream in = new DataInputStream(fstream);
                logger.debug("RequestCache: readConfigurationFile open done file=" + this.path);
                while (in.available() != 0) {
                    String req = in.readLine().trim();
                    logger.debug("RequestCache:readConfigurationFile line:" + req);
                    if (req.startsWith("#")) continue;
                    long ttl = this.timeToLive_;
                    String newreq = null;
                    if (req.startsWith("ttl")) {
                        StringTokenizer st = new StringTokenizer(req);
                        String ttls = st.nextToken();
                        logger.debug("RequestCache:readConfigurationFile ttls:<" + ttls + ">");
                        ttl = Integer.parseInt(ttls.substring(4));
                        newreq = req.substring(ttls.length()).trim();
                    } else {
                        newreq = req;
                    }
                    Pattern p = Pattern.compile(newreq);
                    logger.debug("RequestCache:readConfigurationFile newreq:<" + newreq + ">");
                    logger.debug("RequestCache:readConfigurationFile ttl:<" + ttl + ">");
                    RequestCacheObject uco = new RequestCacheObject(newreq, p, ttl);
                    cache_.put(newreq, uco);
                }
                in.close();
            }
            catch (Exception e) {
                System.err.println("File input error");
                e.printStackTrace();
            }
        }
    }

    public boolean isInCache(String req) {
        if (cache_ != null && cache_.size() == 0) {
            return false;
        }
        if (cache_ == null || requests_ == null || req == null || req.compareTo("") == 0) {
            return false;
        }
        String redir = (String)requests_.get(req);
        if (redir != null) {
            if (redir.compareTo("null") != 0) {
                return ((RequestCacheObject)cache_.get(redir)).isAlive();
            }
            return false;
        }
        if (cache_.containsKey(req)) {
            return ((RequestCacheObject)cache_.get(req)).isAlive();
        }
        Enumeration e = cache_.keys();
        while (e.hasMoreElements()) {
            RequestCacheObject uco = (RequestCacheObject)cache_.get(e.nextElement());
            if (!uco.getPattern().matcher(req).matches()) continue;
            return uco.isAlive();
        }
        return false;
    }

    public synchronized void setResult(String req, Object rset) {
        if (cache_ != null && req != null) {
            RequestCacheObject uco = (RequestCacheObject)cache_.remove(req);
            uco.setResult(rset);
            cache_.put(req, uco);
        }
    }

    public Object getResult(String req) {
        if (cache_ != null) {
            String link = (String)requests_.get(req);
            if (link == null) {
                String rsql = this.getSqlPattern(req);
                RequestCacheObject uco = (RequestCacheObject)cache_.get(rsql);
                return uco;
            }
            RequestCacheObject uco = (RequestCacheObject)cache_.get(link);
            if (uco == null) {
                return null;
            }
            Object obj = uco.getResult();
            if (obj != null) {
                return obj;
            }
        }
        return null;
    }

    public String getSqlPattern(String sql) {
        if (cache_ != null && cache_.size() == 0) {
            return null;
        }
        Enumeration e = cache_.keys();
        while (e.hasMoreElements()) {
            RequestCacheObject uco = (RequestCacheObject)cache_.get(e.nextElement());
            if (!uco.getPattern().matcher(sql).matches()) continue;
            return uco.getRequest();
        }
        return null;
    }

    public void setLink(String sql, String pattern) {
        if (cache_ != null && cache_.size() != 0 && requests_ != null && sql != null && pattern != null) {
            requests_.put(sql, pattern);
        }
    }

    public synchronized void reset() {
        Enumeration e = cache_.keys();
        while (e.hasMoreElements()) {
            RequestCacheObject uco = (RequestCacheObject)cache_.get(e.nextElement());
            uco.close();
            Object var2_2 = null;
        }
        cache_.clear();
        cache_ = null;
        cache_ = new Hashtable();
        requests_.clear();
        requests_ = null;
        requests_ = new Hashtable();
        this.readConfigurationFile();
    }

    public String toString() {
        String s;
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("=== DUMP REQUESTS ===\n");
        Enumeration e = requests_.keys();
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            sbuf.append("key=<" + s + "> value=<" + (String)requests_.get(s) + ">\n");
        }
        sbuf.append("=== DUMP CACHE ===\n");
        e = cache_.keys();
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            RequestCacheObject uco = (RequestCacheObject)cache_.get(s);
            sbuf.append("key(pattern)=<" + s + "> value(RequestCacheObject)=<" + uco.toString() + ">\n");
        }
        return sbuf.toString();
    }
}

