/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.enhydra.jdbc.util.Logger;

public class LRUCache {
    private Hashtable cache = new Hashtable();
    private LinkedList lru = new LinkedList();
    private int maxSize;
    public Logger log;

    public LRUCache(int maxSize) {
        this.maxSize = maxSize;
    }

    public int LRUSize() {
        return this.lru.size();
    }

    public int cacheSize() {
        return this.cache.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object key, Object value) {
        ArrayList<Object> removed = new ArrayList<Object>();
        LRUCache lRUCache = this;
        synchronized (lRUCache) {
            while (this.cache.size() + 1 > this.maxSize) {
                removed.add(this.removeLRU());
            }
            if (this.cache.containsKey(key)) {
                this.lru.remove(key);
            }
            this.lru.addLast(key);
            this.cache.put(key, value);
        }
        this.cleanupAll(removed);
    }

    public synchronized Object get(Object key) {
        if (!this.cache.containsKey(key)) {
            return null;
        }
        this.lru.remove(key);
        this.lru.addLast(key);
        return this.cache.get(key);
    }

    public synchronized Object remove(Object key) {
        if (!this.cache.containsKey(key)) {
            return null;
        }
        this.lru.remove(key);
        Object obj = this.cache.remove(key);
        return obj;
    }

    private synchronized Object removeLRU() {
        Object obj = this.cache.remove(this.lru.getFirst());
        this.lru.removeFirst();
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(int newSize) {
        if (newSize <= 0) {
            return;
        }
        ArrayList<Object> removed = new ArrayList<Object>();
        LRUCache lRUCache = this;
        synchronized (lRUCache) {
            this.maxSize = newSize;
            while (this.cache.size() > this.maxSize) {
                removed.add(this.removeLRU());
            }
        }
        this.cleanupAll(removed);
    }

    private void cleanupAll(List removed) {
        Iterator it = removed.iterator();
        while (it.hasNext()) {
            this.cleanupObject(it.next());
        }
    }

    protected void cleanupObject(Object o) {
    }

    public void cleanupAll() {
        Enumeration enumeration = this.cache.keys();
        while (enumeration.hasMoreElements()) {
            Object o = this.remove(enumeration.nextElement());
            this.cleanupObject(o);
        }
    }

    public void setLogger(Logger alog) {
        this.log = alog;
    }
}

