/*
 * Copyright (C) 2018 - present by PyXLL Ltd.
 */
package com.exceljava.jinx;

import java.util.HashSet;
import java.util.Set;

/**
 * The Rtd class is returned by methods annotated with ExcelFunction
 * that return real time data instead of a single value.
 */
public class Rtd<T> {
    private long ptr = 0;
    private ExcelAddIn xl;
    private Object value;
    private Throwable error;
    private boolean connected = false;
    private boolean disconnected = false;
    private Set<RtdReference> references = new HashSet<RtdReference>();

    public Rtd(T initialValue) {
        this.value = initialValue;
    }

    public Rtd() {
    }

    /**
     * Notify Excel that the current value has changed.
     *
     * @param value The new value to be displayed in Excel.
     */
    public void notify(T value) {
        this.value = value;
        this.error = null;
        if (null != xl) {
            xl.notify(this);
        }
    }

    /**
     * Notify Excel that an error has occured.
     *
     * @param error The error to be displayed in Excel.
     */
    public void notifyError(Throwable error) {
        this.error = error;
        this.value = null;
        if (null != xl) {
            xl.notify(this);
        }
    }

    /**
     * Test whether the Rtd object is connected to Excel.
     * After the Rtd instance is returned to Excel it will
     * be connected and Excel will start receiving updates.
     * It is safe to call notify before the Rtd instance
     * is connected.
     *
     * @return true if connected, false otherwise.
     */
    public boolean isConnected() {
        return connected;
    }

    /**
     * Test whether the Rtd object has been disconnected from Excel.
     * If the cell referencing this Rtd value has been cleared
     * the Rtd object is disconnected.
     *
     * @return true if disconnected, false otherwise.
     */
    public boolean isDisconnected() {
        return disconnected;
    }

    /**
     * Called when Excel connects to this Rtd instance.
     * Excel will begin updating after connecting.
     */
    public void onConnected() {
    }

    /**
     * Called when Excel disconnects to this Rtd instance.
     * Excel will stop updating after disconnecting.
     */
    public void onDisconnected() {
    }
}
