package com.exceljava.jinx;

/**
 * <p>IUnknown is a wrapper around a COM IUnknown pointer.</p>
 *
 * <p>Generally this will be used in conjunction with a Java/COM
 * bridge, such as <a href="https://github.com/exceljava/jinx-com4j" target="_blank">jinx-com4j</a>.</p>
 */
public interface IUnknown {
    /**
     * Convert an IUnknown to another COM interface.
     *
     * This requires a Java-COM bridge, such as jinx-com4j.
     * See https://github.com/exceljava/jinx-com4j.
     *
     * @param cls COM wrapper class to cast to.
     * @param <T> COM wrapper class to cast to.
     * @return COM object cast to 'cls'.
     * @since 2.0
     */
    <T> T queryInterface(Class<T> cls);

    /**
     * The returned long is a reference to an IUnknown C pointer.
     *
     * This is a low level call only intended for supporting libraries
     * and shouldn't need to be called by user code.
     *
     * @param addRef If true, IUnknown::AddRef will be called
     *               before returning the pointer.
     * @return Pointer to reference of an IUnknown COM object.
     * @since 2.0
     */
    long getPointer(boolean addRef);

    /**
     * Release the reference to the IUnknown pointer.
     *
     * Calls to getPointer and queryInterface made after the object
     * has been closed will fail.
     *
     * @since 2.0
     */
    void close();
}
