/*
 * Copyright (C) 2017 - present by PyXLL Ltd.
 */
package com.exceljava.jinx;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * ExcelMacro annotation for methods that should be
 * exposed as Excel macro functions.
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface ExcelMacro {

    /**
     * Name of the function as it will appear in Excel.
     */
    String value() default "";

    /*
     * Assigns a keyboard shortcut to the macro.
     *
     * Shortcuts should be one or more modifier key names (Ctrl, Shift or Alt)
     * and a key, separated by the '+' symbol. For example, 'Ctrl+Shift+R'.
     */
    String shortcut() default "";

    /**
     * Not currently used.
     */
    boolean allowAbort() default false;

    /**
     * If the result of the function is an array, transpose the array before
     * returning to Excel.
     *
     * This can be used for returning a 1d array as a row instead of a
     * column, for example.
     */
    boolean transpose() default false;
}
