/*
 * Copyright (C) 2017 - present by PyXLL Ltd.
 */
package com.exceljava.jinx;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * <p>ExcelArgumentConverter annotation for methods that are used
 * to convert standard Excel types to Java types.</p>
 *
 * <p>Other methods called by Jinx from Excel (e.g. via
 * {@link com.exceljava.jinx.ExcelFunction} can take parameters of any
 * type with an argument converter, as well as the types natively
 * supported by Jinx.</p>
 *
 * <p>For example, if you wanted to represent an enum in Excel as a string,
 * you could register an argument converter that would convert a String
 * to your enum. Methods taking that enum could be called from Excel,
 * with the enum argument being automatically converted via your conversion
 * method.</p>
 *
 * <p>The annotated method takes a parameter of the type it's
 * converting from, and returns an instance of the type it's converting
 * to.</p>
 *
 * <p>Generic return types may also be used. If the return type is a
 * generic type {@code T}, the method should take a second parameter of
 * {@code Class<T>}.</p>
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface ExcelArgumentConverter {
}
