/*
 * Copyright (C) 2017 - present by PyXLL Ltd.
 */
package com.exceljava.jinx;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * <p>ExcelArgument annotation for arguments of methods
 * exposed as Excel worksheet functions.</p>
 *
 * <p>The ExcelArgument annotations are added to the method
 * in the same order as the method parameters.</p>
 *
 * @see ExcelArguments
 */
@Retention(RetentionPolicy.RUNTIME)
public @interface ExcelArgument {

    /**
     * Argument name as it will appear in Excel.
     */
    String value();

    /**
     * Argument description as it will appear in the Excel
     * function wizard.
     */
    String description() default "";

    /**
     * If true, if the argument in Excel is an error (eg #N/A etc)
     * then it will be passed to the Java method as null.
     *
     * For array arguments, if any of the elements in the array is
     * an error it will be replaced with null.
     */
    boolean treatErrorsAsNull() default false;
}
