/*
 * Copyright (C) 2019 - present by PyXLL Ltd.
 */
package com.exceljava.jinx;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * ExcelAction annotation for methods that should be
 * exposed as Excel ribbon actions.
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface ExcelAction {

    /**
     * Identifier used in the ribbon XML for this action.
     */
    String value() default "";
}
