/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.bucketfs.list;

import com.exasol.bucketfs.BucketAccessException;
import com.exasol.bucketfs.list.ListingRetriever;
import com.exasol.errorreporting.ExaError;
import java.net.URI;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class BucketContentLister {
    private final URI bucketUri;
    private final ListingRetriever listingRetriever;
    private final String readPassword;

    public BucketContentLister(URI bucketUri, ListingRetriever listingRetriever, String readPassword) {
        this.bucketUri = bucketUri;
        this.listingRetriever = listingRetriever;
        this.readPassword = readPassword;
    }

    public List<String> retrieve(String path, boolean recursive) throws BucketAccessException {
        String prefix = ListingRetriever.removeLeadingSeparator(path);
        List<String> list = this.listingRetriever.retrieve(this.bucketUri, this.readPassword).filter(e -> e.startsWith(prefix)).map(e -> ListingRetriever.removeLeadingSeparator(e.substring(prefix.length()))).map(recursive ? Function.identity() : this::extractFirstPathComponent).distinct().collect(Collectors.toList());
        if (list.isEmpty()) {
            throw new BucketAccessException(ExaError.messageBuilder((String)"E-BFSJ-11").message("Unable to list contents of {{path}} in bucket {{bucket}}: No such file or directory.", new Object[]{path, this.bucketUri}).toString());
        }
        return list;
    }

    private String extractFirstPathComponent(String path) {
        int i = path.indexOf("/");
        return i < 0 ? path : path.substring(0, i + 1);
    }
}

