/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.bucketfs.jsonrpc;

import com.exasol.bucketfs.http.HttpClientBuilder;
import com.exasol.bucketfs.jsonrpc.Authenticator;
import com.exasol.bucketfs.jsonrpc.BasicAuthAuthenticator;
import com.exasol.bucketfs.jsonrpc.BearerTokenAuthenticator;
import com.exasol.bucketfs.jsonrpc.CreateBucketCommand;
import com.exasol.bucketfs.jsonrpc.JsonMapper;
import com.exasol.bucketfs.jsonrpc.JsonRpcClient;
import com.exasol.bucketfs.jsonrpc.JsonRpcCommandExecutor;
import com.exasol.errorreporting.ExaError;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.security.cert.X509Certificate;

public class CommandFactory {
    private final JsonMapper jsonMapper;
    private final JsonRpcCommandExecutor executor;

    private CommandFactory(JsonRpcCommandExecutor executor, JsonMapper jsonMapper) {
        this.executor = executor;
        this.jsonMapper = jsonMapper;
    }

    public CreateBucketCommand.CreateBucketCommandBuilder makeCreateBucketCommand() {
        return CreateBucketCommand.builder(this.executor, this.jsonMapper);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final HttpClientBuilder httpClientBuilder = new HttpClientBuilder();
        private URI serviceUri;
        private Authenticator authenticator;

        private Builder() {
        }

        public Builder raiseTlsErrors(boolean raise) {
            this.httpClientBuilder.raiseTlsErrors(raise);
            return this;
        }

        public Builder certificate(X509Certificate certificate) {
            this.httpClientBuilder.certificate(certificate);
            return this;
        }

        public Builder serverUrl(String serverUrl) {
            this.serviceUri = this.parseUri(serverUrl);
            return this;
        }

        private URI parseUri(String uri) {
            try {
                return new URI(uri);
            }
            catch (URISyntaxException exception) {
                throw new IllegalArgumentException(ExaError.messageBuilder((String)"E-BFSJ-19").message("Error parsing server URL {{serverUrl}}.", new Object[]{uri}).mitigation("Use a valid format for the URL.", new Object[0]).toString(), exception);
            }
        }

        public Builder bearerTokenAuthentication(String token) {
            this.authenticator = new BearerTokenAuthenticator(token);
            return this;
        }

        public Builder basicAuthentication(String username, String password) {
            this.authenticator = new BasicAuthAuthenticator(username, password);
            return this;
        }

        public CommandFactory build() {
            JsonMapper jsonMapper = JsonMapper.create();
            HttpClient httpClient = this.httpClientBuilder.build();
            JsonRpcClient client = new JsonRpcClient(httpClient, jsonMapper, this.authenticator, this.serviceUri);
            JsonRpcCommandExecutor executor = new JsonRpcCommandExecutor(client, jsonMapper);
            return new CommandFactory(executor, jsonMapper);
        }
    }
}

