/*
 * Decompiled with CFR 0.152.
 */
package com.evergage.android.promote;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evergage.android.internal.util.JSONUtil;
import com.evergage.android.promote.CategorizedItem;
import org.json.JSONObject;

public class Product
extends CategorizedItem {
    @Nullable
    public Double price;
    @Nullable
    public String priceDescription;
    @Nullable
    public Double listPrice;
    @Nullable
    public String currency;
    @Nullable
    public Integer inventoryCount;
    @Nullable
    public String alternateId;

    public Product(@NonNull String id2) {
        super(id2);
    }

    @Override
    @Nullable
    public JSONObject toJSONObject() {
        JSONObject productJson = super.toJSONObject();
        if (productJson == null) {
            return null;
        }
        JSONUtil.put(productJson, "price", this.price);
        JSONUtil.put(productJson, "priceDescription", this.priceDescription);
        JSONUtil.put(productJson, "listPrice", this.listPrice);
        JSONUtil.put(productJson, "currency", this.currency);
        JSONUtil.put(productJson, "inventoryCount", this.inventoryCount);
        JSONUtil.put(productJson, "alternateId", this.alternateId);
        JSONUtil.put(productJson, "isProduct", true);
        return productJson;
    }

    @Nullable
    public static Product fromJSONObject(@NonNull JSONObject json, @NonNull String id2) {
        Product newProduct = new Product(id2);
        newProduct.setFieldsFromJson(json);
        newProduct.price = JSONUtil.getDouble(json, "price");
        newProduct.priceDescription = JSONUtil.getString(json, "priceDescription");
        newProduct.listPrice = JSONUtil.getDouble(json, "listPrice");
        newProduct.currency = JSONUtil.getString(json, "currency");
        newProduct.inventoryCount = JSONUtil.getInteger(json, "inventoryCount");
        newProduct.alternateId = JSONUtil.getString(json, "alternateId");
        return newProduct;
    }
}

