/*
 * Decompiled with CFR 0.152.
 */
package com.evergage.android.promote;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evergage.android.internal.util.JSONUtil;
import com.evergage.android.promote.LineItem;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Order {
    @Nullable
    public String orderId;
    @Nullable
    public List<LineItem> lineItems;
    @Nullable
    public Double totalValue;
    @Nullable
    public String totalValueCurrency;

    public Order(@Nullable String orderId, @Nullable List<LineItem> lineItems, @Nullable Double totalValue) {
        this.orderId = orderId;
        this.lineItems = lineItems;
        this.totalValue = totalValue;
    }

    @Nullable
    public JSONObject toJSONObject() {
        JSONObject orderJson = new JSONObject();
        JSONUtil.put(orderJson, "orderId", this.orderId);
        JSONUtil.put(orderJson, "totalValue", this.totalValue);
        JSONUtil.put(orderJson, "totalValueCurrency", this.totalValueCurrency);
        if (this.lineItems != null) {
            JSONArray jsonLineItems = new JSONArray();
            ArrayList<LineItem> currentLineItems = new ArrayList<LineItem>(this.lineItems);
            for (LineItem lineItem : currentLineItems) {
                JSONObject jsonLineItem = lineItem.toJSONObject();
                if (jsonLineItem == null) continue;
                JSONUtil.arrayPut(jsonLineItems, jsonLineItem, true);
            }
            if (jsonLineItems.length() > 0) {
                JSONUtil.put(orderJson, "lineItems", jsonLineItems);
            }
        }
        return orderJson;
    }

    @Nullable
    public static Order fromJSONObject(@NonNull JSONObject json) {
        if (json == null) {
            return null;
        }
        String orderIdJson = JSONUtil.getString(json, "orderId");
        Double totalValue = JSONUtil.getDouble(json, "totalValue");
        JSONArray lineItemsFromJson = JSONUtil.getJSONArray(json, "lineItems");
        ArrayList<LineItem> lineItemList = new ArrayList<LineItem>();
        if (lineItemsFromJson != null) {
            for (int i = 0; i < lineItemsFromJson.length(); ++i) {
                LineItem currentLineItem = LineItem.fromJSONObject(JSONUtil.arrayGetJSONObject(lineItemsFromJson, i));
                if (currentLineItem == null) continue;
                lineItemList.add(currentLineItem);
            }
            if (lineItemList.isEmpty()) {
                lineItemList = null;
            }
        }
        Order newOrder = new Order(orderIdJson, lineItemList, totalValue);
        newOrder.totalValueCurrency = JSONUtil.getString(json, "totalValueCurrency");
        return newOrder;
    }
}

