/*
 * Decompiled with CFR 0.152.
 */
package com.evergage.android.promote;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evergage.android.internal.util.JSONUtil;
import com.evergage.android.internal.util.StringUtil;
import com.evergage.android.promote.CategorizedItem;
import java.util.Date;
import org.json.JSONObject;

public class Article
extends CategorizedItem {
    @Nullable
    public Date modifiedDate;
    @Nullable
    public String subTitle;

    public Article(@NonNull String id2) {
        super(id2);
    }

    @Override
    @Nullable
    public JSONObject toJSONObject() {
        JSONObject articleJson = super.toJSONObject();
        if (articleJson == null) {
            return null;
        }
        JSONUtil.put(articleJson, "modifiedDate", this.modifiedDate == null ? null : Long.valueOf(this.modifiedDate.getTime()));
        JSONUtil.put(articleJson, "subtitle", StringUtil.truncate("subTitle", this.subTitle));
        return articleJson;
    }

    @Nullable
    public static Article fromJSONObject(@NonNull JSONObject json, @NonNull String id2) {
        Article newArticle = new Article(id2);
        newArticle.setFieldsFromJson(json);
        Long modifiedLong = JSONUtil.getLong(json, "modifiedDate");
        newArticle.modifiedDate = modifiedLong == null ? null : new Date(modifiedLong);
        newArticle.subTitle = JSONUtil.getString(json, "subtitle");
        return newArticle;
    }
}

