/*
 * Decompiled with CFR 0.152.
 */
package com.evergage.android.internal.util;

import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evergage.android.internal.Constants;
import com.evergage.android.internal.DependencyManager;
import com.evergage.android.internal.util.JSONUtil;
import com.evergage.android.internal.util.Logger;
import com.evergage.android.internal.util.NetworkingUtil;
import com.evergage.android.internal.util.SafetyUtil;
import com.evergage.android.internal.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.nio.channels.FileLock;
import org.json.JSONArray;
import org.json.JSONObject;

public class Persistence {
    private static final String TAG = "Persistence";

    @Nullable
    public static JSONObject loadJSONFromFile(@NonNull String fileName) {
        String jsonString = Persistence.loadJSONStringFromFile(fileName);
        if (jsonString == null) {
            return null;
        }
        return JSONUtil.jsonObjectFromString(jsonString);
    }

    @Nullable
    public static JSONArray loadJSONArrayFromFile(@NonNull String fileName) {
        String jsonString = Persistence.loadJSONStringFromFile(fileName);
        if (jsonString == null) {
            return null;
        }
        return JSONUtil.jsonArrayFromString(jsonString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Nullable
    private static String loadJSONStringFromFile(@NonNull String fileName) {
        String jsonString;
        String filePath;
        block21: {
            FileLock fileLock;
            FileInputStream fileInputStream;
            block20: {
                String filesDir;
                if (!StringUtil.isValid(fileName) || !StringUtil.isValid(filesDir = Persistence.getFilesDir())) {
                    return null;
                }
                filePath = Persistence.getFilePath(filesDir, fileName);
                fileInputStream = null;
                fileLock = null;
                jsonString = null;
                File file = new File(filePath);
                fileInputStream = new FileInputStream(file);
                byte[] bytes = NetworkingUtil.byteArrayFromInputStream(fileInputStream, (int)file.length());
                if (bytes.length <= 0) break block20;
                jsonString = new String(bytes, Constants.CHARSET_UTF_8);
            }
            SafetyUtil.closeSafely(fileInputStream, true);
            try {
                if (fileLock != null) {
                    fileLock.release();
                }
                break block21;
            }
            catch (Exception e) {
                Logger.log(2000, TAG, e, "Error releasing file lock");
            }
            break block21;
            catch (FileNotFoundException e) {
                Logger.log(4000, TAG, null, "File not found: ", filePath);
                String string = null;
                SafetyUtil.closeSafely(fileInputStream, true);
                try {
                    if (fileLock != null) {
                        fileLock.release();
                    }
                }
                catch (Exception e2) {
                    Logger.log(2000, TAG, e2, "Error releasing file lock");
                }
                return string;
            }
            catch (Exception e2) {
                Logger.log(1000, TAG, e2, "Error reading file: ", filePath);
                {
                    catch (Throwable throwable) {
                        SafetyUtil.closeSafely(fileInputStream, true);
                        try {
                            if (fileLock != null) {
                                fileLock.release();
                            }
                        }
                        catch (Exception e3) {
                            Logger.log(2000, TAG, e3, "Error releasing file lock");
                        }
                        throw throwable;
                    }
                }
                SafetyUtil.closeSafely(fileInputStream, true);
                try {
                    if (fileLock != null) {
                        fileLock.release();
                    }
                }
                catch (Exception e4) {
                    Logger.log(2000, TAG, e4, "Error releasing file lock");
                }
            }
        }
        if (!StringUtil.isValid(jsonString)) {
            Logger.log(1000, TAG, null, "Resulting JSON string is null or empty: ", filePath);
            return null;
        }
        return jsonString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void saveRawJSONToFile(@NonNull String fileName, @NonNull String json) {
        block20: {
            String filesDir;
            if (!(StringUtil.isValid(fileName) && StringUtil.isValid(json) && StringUtil.isValid(filesDir = Persistence.getFilesDir()))) {
                return;
            }
            File folder = new File(filesDir);
            if (!folder.exists() && !folder.mkdir()) {
                Logger.log(1000, TAG, null, "Unable to create files dir: ", filesDir);
                return;
            }
            String filePath = Persistence.getFilePath(filesDir, fileName);
            FileOutputStream fileOutputStream = null;
            FileLock fileLock = null;
            fileOutputStream = new FileOutputStream(filePath);
            fileOutputStream.write(json.getBytes(Constants.CHARSET_UTF_8));
            fileOutputStream.flush();
            fileOutputStream.getFD().sync();
            SafetyUtil.closeSafely(fileOutputStream, true);
            try {
                if (fileLock != null) {
                    fileLock.release();
                }
                break block20;
            }
            catch (Exception e) {
                Logger.log(2000, TAG, e, "Error releasing file lock");
            }
            break block20;
            catch (FileNotFoundException e) {
                Logger.log(1000, TAG, e, "Couldn't find files dir: ", filePath);
                SafetyUtil.closeSafely(fileOutputStream, true);
                try {
                    if (fileLock != null) {
                        fileLock.release();
                    }
                }
                catch (Exception e2) {
                    Logger.log(2000, TAG, e2, "Error releasing file lock");
                }
            }
            catch (Exception e2) {
                Logger.log(1000, TAG, e2, "Error writing to file: ", filePath);
                {
                    catch (Throwable throwable) {
                        SafetyUtil.closeSafely(fileOutputStream, true);
                        try {
                            if (fileLock != null) {
                                fileLock.release();
                            }
                        }
                        catch (Exception e3) {
                            Logger.log(2000, TAG, e3, "Error releasing file lock");
                        }
                        throw throwable;
                    }
                }
                SafetyUtil.closeSafely(fileOutputStream, true);
                try {
                    if (fileLock != null) {
                        fileLock.release();
                    }
                }
                catch (Exception e4) {
                    Logger.log(2000, TAG, e4, "Error releasing file lock");
                }
            }
        }
    }

    @Nullable
    private static String getFilesDir() {
        Context appContext = DependencyManager.getAppContext();
        if (appContext == null) {
            Logger.log(2000, TAG, null, "Unable to read or write config, Application not provided to Evergage.initialize()");
            return null;
        }
        String filePath = Build.VERSION.SDK_INT >= 21 ? appContext.getNoBackupFilesDir().getPath() + File.separator + "evergage" : appContext.getFilesDir().getPath() + File.separator + "evergage";
        return filePath;
    }

    @NonNull
    private static String getFilePath(@NonNull String filesDir, @NonNull String fileName) {
        return filesDir + File.separator + fileName;
    }

    public static void deleteFilename(@NonNull String fileName) {
        String filesDir = Persistence.getFilesDir();
        if (filesDir == null) {
            return;
        }
        String filePath = Persistence.getFilePath(filesDir, fileName);
        File file = new File(filePath);
        if (file.exists() && !file.delete()) {
            Logger.log(1000, TAG, null, "Error removing file ", filePath);
        }
    }
}

