/*
 * Decompiled with CFR 0.152.
 */
package com.evergage.android.internal.util;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evergage.android.internal.Constants;
import com.evergage.android.internal.util.Logger;
import com.evergage.android.internal.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;

public class NetworkingUtil {
    private static final String TAG = "NetworkingUtil";
    private static final SimpleDateFormat httpDateFormatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Constants.LOCALE_POSIX);

    @Nullable
    public static String httpDateStringFromMillis(@NonNull Long millis) {
        if (millis == null) {
            return null;
        }
        return httpDateFormatter.format(new Date(millis));
    }

    @Nullable
    public static Long millisFromHttpDateString(@NonNull String httpDateString) {
        if (!StringUtil.isValid(httpDateString)) {
            return null;
        }
        try {
            Date date = httpDateFormatter.parse(httpDateString);
            return date.getTime();
        }
        catch (Exception e) {
            Logger.log(2000, TAG, e, "Error parsing httpDateString");
            return null;
        }
    }

    @NonNull
    public static byte[] byteArrayFromInputStream(@Nullable InputStream inputStream, int contentLength) throws IOException {
        byte[] data;
        if (inputStream == null) {
            return new byte[0];
        }
        if (contentLength > 0) {
            int count;
            data = new byte[contentLength];
            for (int n = 0; n < contentLength; n += count) {
                count = inputStream.read(data, n, contentLength - n);
                if (count >= 0) continue;
                throw new EOFException("less bytes than reported contentLength");
            }
        } else {
            int numRead;
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((numRead = inputStream.read(buffer, 0, buffer.length)) != -1) {
                byteStream.write(buffer, 0, numRead);
            }
            byteStream.flush();
            data = byteStream.toByteArray();
        }
        return data;
    }

    @Nullable
    public static Uri addQueryParams(@NonNull Map<String, String> params, @NonNull Uri toURL) {
        if (params == null || params.isEmpty() || toURL == null) {
            return toURL;
        }
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Uri.Builder builder = toURL.buildUpon();
        for (String key : params.keySet()) {
            if (StringUtil.isValid(key)) continue;
            Logger.log(2000, TAG, null, "Ignoring URL param key, is empty or null");
            keys.remove(key);
        }
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String a, String b) {
                return String.valueOf(a).compareTo(String.valueOf(b));
            }
        });
        for (String key : keys) {
            String valString = params.get(key);
            if (StringUtil.isValid(valString)) {
                builder.appendQueryParameter(key, valString);
                continue;
            }
            Logger.log(2000, TAG, null, "Ignoring URL param value, is empty or null: ", valString);
        }
        try {
            return builder.build();
        }
        catch (Exception e) {
            Logger.log(2000, TAG, e, "Error building URL: ", builder.toString());
            return null;
        }
    }

    public static int connectivityProblemForError(Exception e) {
        if (e instanceof SocketTimeoutException || e.getCause() instanceof SocketTimeoutException || e instanceof UnknownHostException || e.getCause() instanceof UnknownHostException) {
            Logger.log(2000, TAG, null, "Could not send request. Could not contact Evergage: ", e.toString());
            return 2;
        }
        if (e instanceof SocketException || e.getCause() instanceof SocketException) {
            Logger.log(2000, TAG, null, "Could not send request. General network connectivity problem: ", e.toString());
            return 1;
        }
        return 0;
    }

    public static boolean openURLFromString(@NonNull Context context, @NonNull String urlString) {
        if (!StringUtil.isValid(urlString)) {
            return false;
        }
        try {
            Uri uri = Uri.parse((String)urlString);
            if (!StringUtil.isValid(uri.getScheme())) {
                uri = uri.buildUpon().scheme("http").build();
            }
            Intent viewUriIntent = new Intent("android.intent.action.VIEW", uri);
            viewUriIntent.addFlags(0x18000000);
            if (viewUriIntent.resolveActivity(context.getPackageManager()) == null) {
                Logger.log(2000, TAG, null, "Could not resolve Activity for url: ", urlString);
                return false;
            }
            context.startActivity(viewUriIntent);
            Logger.log(3000, TAG, null, "Started Activity for url: ", urlString);
            return true;
        }
        catch (Exception e) {
            Logger.log(2000, TAG, e, "Could not start Activity for url: ", urlString);
            return false;
        }
    }

    static {
        httpDateFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConnectivityProblem {
        public static final int NONE = 0;
        public static final int NETWORK = 1;
        public static final int HOST = 2;
        public static final int AUTH = 3;
    }
}

