/*
 * Decompiled with CFR 0.152.
 */
package com.evergage.android.internal.util;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evergage.android.internal.util.HostAppUtil;

public class Logger {
    private static volatile int logThreshold = -1;

    public static void setLogThresholdToDefault(boolean onlyIfNotSet) {
        if (onlyIfNotSet && logThreshold >= 0) {
            return;
        }
        int level = 0;
        if (HostAppUtil.appIsDebugBuildOrDebuggable()) {
            level = 2000;
        }
        Logger.setLogThreshold(level);
    }

    public static void setLogThreshold(int level) {
        logThreshold = level;
    }

    public static void log(int level, @NonNull String classNameOrSubTag, @Nullable Throwable throwable, String ... args) {
        if (level < 1000 || level > logThreshold && level != Integer.MAX_VALUE) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" [");
        sb.append(classNameOrSubTag);
        sb.append("] ");
        if (args != null) {
            for (String s : args) {
                sb.append(s);
            }
        }
        if (level == Integer.MAX_VALUE) {
            Log.e((String)"Evergage", (String)sb.toString(), (Throwable)throwable);
        } else if (level >= 4000) {
            Log.d((String)"Evergage", (String)sb.toString(), (Throwable)throwable);
        } else if (level >= 3000) {
            Log.i((String)"Evergage", (String)sb.toString(), (Throwable)throwable);
        } else if (level >= 2000) {
            Log.w((String)"Evergage", (String)sb.toString(), (Throwable)throwable);
        } else if (level >= 1000) {
            Log.e((String)"Evergage", (String)sb.toString(), (Throwable)throwable);
        }
    }
}

