/*
 * Decompiled with CFR 0.152.
 */
package com.evergage.android.internal;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evergage.android.Campaign;
import com.evergage.android.CampaignHandler;
import com.evergage.android.internal.Alert;
import com.evergage.android.internal.CampaignImpl;
import com.evergage.android.internal.Config;
import com.evergage.android.internal.ContextImpl;
import com.evergage.android.internal.DependencyManager;
import com.evergage.android.internal.EvergageImpl;
import com.evergage.android.internal.InAppMessage;
import com.evergage.android.internal.util.Logger;
import com.evergage.android.internal.util.SafetyUtil;

@MainThread
class UIManager
implements CampaignHandler {
    private static final String TAG = "UIManager";
    private DependencyManager.LazyNonNull<EvergageImpl> lazyEvergage = DependencyManager.lazyGetEvergage();
    @Nullable
    private Context appContext = DependencyManager.getAppContext();
    @NonNull
    private Config config = DependencyManager.getConfig();
    @NonNull
    private ContextImpl globalContext = DependencyManager.getGlobalContext();
    private boolean started = false;
    @Nullable
    private Alert alert;
    @Nullable
    private InAppMessage inAppMessage;
    @NonNull
    private final SafetyUtil.Timer alertTimer = new SafetyUtil.Timer(SafetyUtil.sMainHandler, new SafetyUtil.SafeRunnable(){

        @Override
        public void runImpl() {
            if (UIManager.this.alertTimer.isCancelledOrNotStarted()) {
                return;
            }
            UIManager.this.hideAlert();
        }
    });

    UIManager() {
    }

    void reset() {
        SafetyUtil.assertOnMain();
        this.stopSystemsAsNecessary();
        this.lazyEvergage = DependencyManager.lazyGetEvergage();
        this.appContext = DependencyManager.getAppContext();
        this.config = DependencyManager.getConfig();
        this.globalContext = DependencyManager.getGlobalContext();
    }

    void startSystemsAsNecessary() {
        SafetyUtil.assertOnMain();
        if (this.started || !this.lazyEvergage.get().isRunning()) {
            return;
        }
        this.started = true;
        this.globalContext.setCampaignHandler(this, "evg_mn", false);
    }

    void stopSystemsAsNecessary() {
        SafetyUtil.assertOnMain();
        if (!this.started || this.lazyEvergage.get().isRunning()) {
            return;
        }
        this.started = false;
        this.hideAlert();
        this.removeInAppMessageView(false, true);
        this.globalContext.setCampaignHandler(null, "evg_mn", false);
    }

    @Override
    public void handleCampaign(final @NonNull Campaign campaign) {
        SafetyUtil.assertOnMain();
        if (!this.started) {
            return;
        }
        new SafetyUtil.SafeRunnable(){

            @Override
            public void runImpl() {
                if (!(campaign instanceof CampaignImpl.InAppMessageCampaign)) {
                    Logger.log(2000, UIManager.TAG, null, "Ignoring unexpected campaign: ", ((CampaignImpl)campaign).json.toString());
                    return;
                }
                CampaignImpl.InAppMessageCampaign newMsgCampaign = (CampaignImpl.InAppMessageCampaign)campaign;
                InAppMessage oldMessage = UIManager.this.currentInAppMessage();
                if (newMsgCampaign.equals(oldMessage == null ? null : oldMessage.campaign)) {
                    Logger.log(4000, UIManager.TAG, null, "Ignoring equivalent InAppMessage [", newMsgCampaign.getCampaignId(), ":", newMsgCampaign.getExperienceId(), ":", newMsgCampaign.getMessageId(), "], already showing or will show");
                    return;
                }
                InAppMessage newMessage = new InAppMessage(newMsgCampaign);
                UIManager.this.showOrReplaceInAppMessage(newMessage);
            }
        }.run();
    }

    void hideAll() {
        SafetyUtil.assertOnMain();
        this.hideAlert();
        this.hideInAppMessage();
    }

    void showOrReplaceAlert(@NonNull String title, @NonNull String message) {
        SafetyUtil.assertOnMain();
        if (this.appContext == null) {
            return;
        }
        String logTag = title;
        if (logTag.startsWith("Evergage ")) {
            logTag = logTag.substring(9);
        }
        Logger.log(3000, logTag, null, message);
        this.hideAlert();
        Double alertTime = this.config.doubleForKey("designerAlertTime");
        if (alertTime == null || alertTime <= 0.0) {
            return;
        }
        this.alert = new Alert(title, message);
        this.alert.showView();
        this.alertTimer.restartWithDelay((long)(alertTime * 1000.0));
    }

    private void hideAlert() {
        this.alertTimer.cancel();
        if (this.alert == null) {
            return;
        }
        this.alert.removeView();
        this.alert = null;
    }

    private void showOrReplaceInAppMessage(@NonNull InAppMessage inAppMessage) {
        SafetyUtil.assertOnMain();
        if (this.appContext == null || !this.started) {
            return;
        }
        if (inAppMessage.campaign.isControlGroup()) {
            Logger.log(3000, TAG, null, "Tracking impression but not rendering, control group, InAppMessage [", inAppMessage.campaign.getCampaignId(), ":", inAppMessage.campaign.getExperienceId(), ":", inAppMessage.campaign.getMessageId(), "]");
            this.globalContext.trackImpression(inAppMessage.campaign);
            return;
        }
        this.removeInAppMessageView(true, true);
        this.inAppMessage = inAppMessage;
        inAppMessage.showOrUpdateView();
    }

    @Nullable
    InAppMessage currentInAppMessage() {
        SafetyUtil.assertOnMain();
        return this.inAppMessage;
    }

    void hideInAppMessage() {
        SafetyUtil.assertOnMain();
        this.removeInAppMessageView(true, true);
    }

    private void removeInAppMessageView(boolean animated, boolean discard) {
        if (this.inAppMessage == null) {
            return;
        }
        this.inAppMessage.removeView(animated);
        if (discard) {
            this.inAppMessage = null;
        }
    }

    void onResumeEligibleActivity() {
        if (this.inAppMessage != null) {
            this.inAppMessage.showOrUpdateView();
        }
    }

    void onDestroyActivity(@NonNull Activity activity) {
        InAppMessage.removeViewFromActivityIfFound(activity);
    }
}

