/*
 * Decompiled with CFR 0.152.
 */
package com.evergage.android.internal;

import android.app.Activity;
import android.content.Intent;
import android.os.Looper;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evergage.android.EvergageActivity;
import com.evergage.android.Screen;
import com.evergage.android.internal.ContextImpl;
import com.evergage.android.internal.DependencyManager;
import com.evergage.android.internal.EvergageImpl;
import com.evergage.android.internal.util.JSONUtil;
import com.evergage.android.internal.util.Logger;
import com.evergage.android.internal.util.SafetyUtil;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;

class ScreenImpl
extends ContextImpl
implements Screen {
    private static final String TAG = "Screen";
    private static final AtomicInteger atomicIdSource = new AtomicInteger(-1);
    private static Set<String> ignorableClassNames = new HashSet<String>();
    private static final LinkedHashSet<WeakReference<ScreenImpl>> runningScreens = new LinkedHashSet();
    private static final List<ScreenImpl> activityScreens = new LinkedList<ScreenImpl>();
    private final WeakReference<ScreenImpl> weakSelfRef = new WeakReference<ScreenImpl>(this);
    private final WeakReference<Activity> weakParentRef;
    private volatile int state = 0;
    private SafetyUtil.Timer unregisterContextIdTimer;

    private ScreenImpl(@Nullable Activity parent) {
        super(Integer.toString(atomicIdSource.incrementAndGet()));
        this.weakParentRef = new WeakReference<Activity>(parent);
        if (parent != null) {
            Logger.log(4000, TAG, null, "[", this.identifier, "], Init, parent activity [", parent.toString(), "]");
        }
    }

    @Override
    void reset() {
        super.reset();
    }

    @Override
    public boolean isRunning() {
        return this.state == 2;
    }

    private boolean isVisible() {
        return this.state >= 1;
    }

    @MainThread
    private void adjustState(int potentialNewState, int flags) {
        boolean avoidModifyRunningScreens;
        SafetyUtil.assertOnMain();
        int existingState = this.state;
        if (existingState == potentialNewState) {
            return;
        }
        if (this.unregisterContextIdTimer != null) {
            this.unregisterContextIdTimer.cancel();
        }
        this.unregisterContextIdTimer = null;
        boolean avoidStopSystems = 0 != (flags & 1);
        boolean bl = avoidModifyRunningScreens = 0 != (flags & 2);
        if (potentialNewState == 2) {
            if (existingState != 1) {
                Logger.log(2000, TAG, null, "[", this.identifier, "] Unexpected attempt to transition state from ", ScreenImpl.stringForState(existingState), " to ", ScreenImpl.stringForState(potentialNewState));
            }
            if (avoidModifyRunningScreens) {
                Logger.log(2000, TAG, null, "[", this.identifier, "] Ignoring attempt to set running, cannot modify collection");
                return;
            }
            if (!this.makeRoomInRunningScreens()) {
                return;
            }
        }
        this.state = potentialNewState;
        this.logState();
        if (this.state < existingState) {
            if (!avoidModifyRunningScreens) {
                runningScreens.remove(this.weakSelfRef);
            }
            if (!avoidStopSystems) {
                this.stopSystemsAsNecessary();
            }
            if (this.state == 0) {
                Logger.log(3000, TAG, null, "[", this.identifier, "] Clearing all handlers and held campaigns, screen no longer visible");
                this.campaignDispatcher.unregisterContextId(this.identifier);
            }
        } else {
            if (this.state == 2) {
                runningScreens.remove(this.weakSelfRef);
                runningScreens.add(this.weakSelfRef);
            }
            this.startSystemsAsNecessary();
        }
    }

    @MainThread
    private boolean makeRoomInRunningScreens() {
        int removeCount;
        SafetyUtil.assertOnMain();
        Integer maxScreens = this.config.intForKey("maxScreens");
        if (maxScreens == null) {
            maxScreens = 50;
        }
        if ((removeCount = runningScreens.size() - Math.max(0, maxScreens - 1)) > 0) {
            Logger.log(2000, TAG, null, "Setting ", Integer.toString(removeCount), "/", Integer.toString(runningScreens.size()), " screens to not running due to ", Integer.toString(maxScreens), " max screens");
            Iterator iterator = runningScreens.iterator();
            while (iterator.hasNext() && removeCount-- > 0) {
                WeakReference weakScreen = (WeakReference)iterator.next();
                if (weakScreen == null) {
                    iterator.remove();
                    Logger.log(2000, TAG, null, "maxScreens found null element");
                    continue;
                }
                ScreenImpl strongScreen = (ScreenImpl)weakScreen.get();
                if (strongScreen == null) {
                    iterator.remove();
                    Logger.log(2000, TAG, null, "maxScreens found missing strong reference");
                    continue;
                }
                iterator.remove();
                if (!strongScreen.isRunning()) {
                    SafetyUtil.assertFail(2000, "Screen [" + strongScreen.identifier + "] Already not running", null, false);
                    continue;
                }
                strongScreen.adjustState(1, 2);
            }
        }
        if (maxScreens <= 0) {
            Logger.log(2000, TAG, null, "[", this.identifier, "] Ignoring attempt to set running, ", Integer.toString(maxScreens), " max screens");
            return false;
        }
        return true;
    }

    private void logState() {
        Activity activity = (Activity)this.weakParentRef.get();
        Logger.log(3000, TAG, null, "[", this.identifier, "] ", ScreenImpl.stringForState(this.state), ", activity: [", activity != null ? activity.toString() : null, "]");
    }

    @Override
    @MainThread
    protected void stopSystemsAsNecessary() {
        super.stopSystemsAsNecessary();
        if (((EvergageImpl)this.lazyEvergage.get()).isDisabledOrNotInitialized()) {
            this.adjustState(0, 1);
        }
    }

    @Override
    protected boolean allowSetActive(boolean active) {
        if (active) {
            return super.allowSetActive(true) && this.isRunning();
        }
        return super.allowSetActive(false) || !this.isRunning();
    }

    @Override
    @MainThread
    protected void registerContextId() {
        super.registerContextId();
        if (!this.isVisible()) {
            Double delay;
            if (this.unregisterContextIdTimer != null) {
                this.unregisterContextIdTimer.cancel();
            }
            if ((delay = this.config.doubleForKey("campaignDispatchTimeout")) == null || delay <= 0.0) {
                this.unregisterContextIdTimer = null;
                return;
            }
            this.unregisterContextIdTimer = new SafetyUtil.Timer(SafetyUtil.sMainHandler, new SafetyUtil.SafeRunnable(){

                @Override
                @MainThread
                public void runImpl() {
                    SafetyUtil.assertOnMain();
                    if (ScreenImpl.this.unregisterContextIdTimer == null) {
                        return;
                    }
                    ScreenImpl.this.unregisterContextIdTimer.cancel();
                    ScreenImpl.this.unregisterContextIdTimer = null;
                    if (ScreenImpl.this.isVisible()) {
                        return;
                    }
                    Logger.log(2000, ScreenImpl.TAG, null, "[", ScreenImpl.this.identifier, "] Clearing all handlers and held campaigns, screen still not visible");
                    ScreenImpl.this.campaignDispatcher.unregisterContextId(ScreenImpl.this.identifier);
                }
            });
            this.unregisterContextIdTimer.restartWithDelay((long)(delay * 1000.0));
        }
    }

    @MainThread
    static void startSystemsAllScreens() {
        SafetyUtil.assertOnMain();
        for (ScreenImpl screen : activityScreens) {
            screen.startSystemsAsNecessary();
        }
    }

    @MainThread
    static void stopSystemsAllScreens() {
        SafetyUtil.assertOnMain();
        for (ScreenImpl screen : activityScreens) {
            screen.stopSystemsAsNecessary();
        }
        if (((EvergageImpl)DependencyManager.getEvergage()).isDisabledOrNotInitialized()) {
            activityScreens.clear();
        }
    }

    @MainThread
    static void resetAllScreens() {
        SafetyUtil.assertOnMain();
        for (ScreenImpl screen : activityScreens) {
            screen.reset();
        }
    }

    @MainThread
    static void onCreateActivity(@NonNull Activity activity) {
        SafetyUtil.assertOnMain();
        if (((EvergageImpl)DependencyManager.getEvergage()).isDisabledOrNotInitialized()) {
            return;
        }
        if (activity == null) {
            Logger.log(4000, TAG, null, "onCreateActivity, null");
            return;
        }
        ScreenImpl existing = ScreenImpl.forActivity(activity, false);
        if (existing != null) {
            Logger.log(2000, TAG, null, "onCreateActivity, removing existing screen [", existing.identifier, "]");
            activityScreens.remove(existing);
            existing.adjustState(0, 0);
        }
        if (ScreenImpl.isIgnorableActivity(activity)) {
            Logger.log(4000, TAG, null, "onCreateActivity, ignorable Activity: ", activity.toString());
            return;
        }
        ScreenImpl newScreen = new ScreenImpl(activity);
        activityScreens.add(newScreen);
    }

    @MainThread
    static void onStartActivity(@NonNull Activity activity) {
        ScreenImpl screen = ScreenImpl.forActivity(activity, false);
        if (screen != null) {
            screen.adjustState(1, 0);
        }
    }

    @MainThread
    static void onResumeActivity(@NonNull Activity activity) {
        ScreenImpl screen = ScreenImpl.forActivity(activity, false);
        if (screen != null) {
            screen.adjustState(2, 0);
            DependencyManager.getUiManager().onResumeEligibleActivity();
        }
    }

    @MainThread
    static void onPauseActivity(@NonNull Activity activity) {
        ScreenImpl screen = ScreenImpl.forActivity(activity, false);
        if (screen != null) {
            screen.adjustState(1, 0);
        }
    }

    @MainThread
    static void onStopActivity(@NonNull Activity activity) {
        ScreenImpl screen = ScreenImpl.forActivity(activity, true);
        if (screen != null) {
            screen.adjustState(0, 0);
        }
    }

    @MainThread
    static void onDestroyActivity(@NonNull Activity activity) {
        ScreenImpl screen = ScreenImpl.forActivity(activity, false);
        if (screen == null) {
            return;
        }
        Logger.log(4000, TAG, null, "onDestroyActivity, removing screen [", screen.identifier, "]");
        activityScreens.remove(screen);
        screen.adjustState(0, 0);
    }

    @MainThread
    @Nullable
    public static ScreenImpl forActivity(@NonNull Activity activity) {
        return ScreenImpl.forActivity(activity, true);
    }

    @MainThread
    @Nullable
    private static ScreenImpl forActivity(@NonNull Activity activity, boolean warnIfIgnorable) {
        if (Looper.myLooper() != SafetyUtil.sMainLooper) {
            SafetyUtil.assertFail(1000, "getScreenForActivity() called from non-main thread", null, true);
            return null;
        }
        if (((EvergageImpl)DependencyManager.getEvergage()).isDisabledOrNotInitialized()) {
            return null;
        }
        Iterator<ScreenImpl> iterator = activityScreens.iterator();
        while (iterator.hasNext()) {
            ScreenImpl screen = iterator.next();
            if (screen == null) {
                iterator.remove();
                Logger.log(2000, TAG, null, "getScreenForActivity(): cleanup found null reference");
                continue;
            }
            Activity parentActivity = (Activity)screen.weakParentRef.get();
            if (parentActivity == null) {
                Logger.log(2000, TAG, null, "forActivity: cleanup found screen [", screen.identifier, "] with missing activity");
                iterator.remove();
                screen.adjustState(0, 0);
                continue;
            }
            if (!parentActivity.equals(activity)) continue;
            return screen;
        }
        if (activity == null) {
            NullPointerException e = new NullPointerException();
            Logger.log(2000, TAG, e, "forActivity: activity null");
        } else if (warnIfIgnorable) {
            Logger.log(2000, TAG, null, "forActivity: screen not found, called outside lifecycle or ignorable activity: ", activity.toString());
        }
        return null;
    }

    @MainThread
    static int runningWeakRefCount() {
        SafetyUtil.assertOnMain();
        return runningScreens.size();
    }

    @MainThread
    @Nullable
    static Activity lastRunningActivity() {
        SafetyUtil.assertOnMain();
        LinkedList<WeakReference<ScreenImpl>> list = new LinkedList<WeakReference<ScreenImpl>>(runningScreens);
        Iterator<WeakReference<ScreenImpl>> iterator = list.descendingIterator();
        while (iterator.hasNext()) {
            Activity strongActivity;
            ScreenImpl strongScreen = (ScreenImpl)iterator.next().get();
            if (strongScreen == null || !strongScreen.isRunning() || (strongActivity = (Activity)strongScreen.weakParentRef.get()) == null || strongActivity.getWindow() == null) continue;
            return strongActivity;
        }
        return null;
    }

    @MainThread
    static void setIgnorableClassNames(@Nullable JSONArray classNames) {
        SafetyUtil.assertOnMain();
        HashSet<String> newSet = new HashSet<String>();
        if (classNames != null && classNames.length() > 0) {
            for (int index = 0; index < classNames.length(); ++index) {
                String className = JSONUtil.arrayGetString(classNames, index);
                if (className == null) continue;
                newSet.add(className);
            }
        }
        ignorableClassNames = newSet;
    }

    @MainThread
    private static boolean isIgnorableActivity(@NonNull Activity activity) {
        SafetyUtil.assertOnMain();
        if (activity == null) {
            Logger.log(4000, TAG, null, "isIgnorableActivity: null");
            return true;
        }
        if (activity.getClass() == EvergageActivity.class) {
            Logger.log(4000, TAG, null, "isIgnorableActivity: Evergage Activity");
            return true;
        }
        Intent intent = activity.getIntent();
        if (intent != null && "EvergageTesting".equals(intent.getAction())) {
            return false;
        }
        if (activity.getWindow() == null) {
            Logger.log(4000, TAG, null, "isIgnorableActivity: has no window: ", activity.toString());
            return true;
        }
        if (activity.getWindow().getAttributes().type > 1999) {
            Logger.log(4000, TAG, null, "isIgnorableActivity: has system window: ", activity.toString());
            return true;
        }
        if (ignorableClassNames.contains(activity.getClass().getName())) {
            Logger.log(4000, TAG, null, "isIgnorableActivity: ignorable class: ", activity.getClass().getName());
            return true;
        }
        return false;
    }

    @NonNull
    private static String stringForState(int state) {
        switch (state) {
            case 0: {
                return "Invisible";
            }
            case 1: {
                return "Visible";
            }
            case 2: {
                return "Running";
            }
        }
        return "";
    }
}

